/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.persistence.rocksdb.configuration.Attribute;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;

@Namespaces(value={@Namespace(root="rocksdb-store"), @Namespace(uri="urn:infinispan:config:store:rocksdb:*", root="rocksdb-store", since="9.0")})
public class RocksDBStoreConfigurationParser
implements ConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:store:rocksdb:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ROCKSDB_STORE: {
                this.parseRocksDBCacheStore(reader, (RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseRocksDBCacheStore(ConfigurationReader reader, RocksDBStoreConfigurationBuilder builder) {
        String path = null;
        String relativeTo = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block11;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((ConfigurationReader)reader, (int)i);
                    continue block11;
                }
                case CLEAR_THRESHOLD: {
                    if (!reader.getSchema().since(12, 0)) {
                        ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                        continue block11;
                    }
                    throw ParseUtils.attributeRemoved((ConfigurationReader)reader, (int)i);
                }
                case BLOCK_SIZE: {
                    builder.blockSize(Integer.parseInt(value));
                    continue block11;
                }
                case CACHE_SIZE: {
                    builder.cacheSize(Long.parseLong(value));
                    continue block11;
                }
                default: {
                    Parser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        if ((path = ParseUtils.resolvePath(path, relativeTo)) != null) {
            builder.location(path);
        }
        block12: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case EXPIRATION: {
                    this.parseExpiry(reader, builder);
                    continue block12;
                }
                case COMPRESSION: {
                    this.parseCompression(reader, builder);
                    continue block12;
                }
            }
            Parser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    private void parseExpiry(ConfigurationReader reader, RocksDBStoreConfigurationBuilder builder) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    builder.expiredLocation(value);
                    continue block4;
                }
                case QUEUE_SIZE: {
                    if (!reader.getSchema().since(12, 0)) {
                        ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                        continue block4;
                    }
                    throw ParseUtils.attributeRemoved((ConfigurationReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseCompression(ConfigurationReader reader, RocksDBStoreConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case TYPE: {
                    builder.compressionType(CompressionType.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

