/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.Attribute;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationSerializer;

@ConfigurationFor(value=RocksDBStore.class)
@BuiltBy(value=RocksDBStoreConfigurationBuilder.class)
@SerializedWith(value=RocksDBStoreConfigurationSerializer.class)
public class RocksDBStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).immutable().build();
    public static final AttributeDefinition<CompressionType> COMPRESSION_TYPE = AttributeDefinition.builder((Enum)Attribute.COMPRESSION_TYPE, (Object)((Object)CompressionType.NONE)).immutable().autoPersist(false).build();
    static final AttributeDefinition<Integer> BLOCK_SIZE = AttributeDefinition.builder((Enum)Attribute.BLOCK_SIZE, (Object)0).immutable().build();
    static final AttributeDefinition<Long> CACHE_SIZE = AttributeDefinition.builder((Enum)Attribute.CACHE_SIZE, (Object)0L).immutable().build();
    static final AttributeDefinition<Integer> CLEAR_THRESHOLD = AttributeDefinition.builder((Enum)Attribute.CLEAR_THRESHOLD, (Object)10000).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> location;
    private final org.infinispan.commons.configuration.attributes.Attribute<CompressionType> compressionType;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> blockSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> cacheSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> clearThreshold;
    private final RocksDBExpirationConfiguration expiration;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RocksDBStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, COMPRESSION_TYPE, BLOCK_SIZE, CACHE_SIZE, CLEAR_THRESHOLD});
    }

    public RocksDBStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, RocksDBExpirationConfiguration expiration) {
        super(attributes, async);
        this.location = attributes.attribute(LOCATION);
        this.compressionType = attributes.attribute(COMPRESSION_TYPE);
        this.blockSize = attributes.attribute(BLOCK_SIZE);
        this.cacheSize = attributes.attribute(CACHE_SIZE);
        this.clearThreshold = attributes.attribute(CLEAR_THRESHOLD);
        this.expiration = expiration;
    }

    public RocksDBExpirationConfiguration expiration() {
        return this.expiration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String location() {
        return (String)this.location.get();
    }

    public String expiredLocation() {
        return this.expiration.expiredLocation();
    }

    public CompressionType compressionType() {
        return (CompressionType)((Object)this.compressionType.get());
    }

    public Integer blockSize() {
        return (Integer)this.blockSize.get();
    }

    public Long cacheSize() {
        return (Long)this.cacheSize.get();
    }

    @Deprecated
    public int expiryQueueSize() {
        return this.expiration.expiryQueueSize();
    }

    @Deprecated
    public int clearThreshold() {
        return (Integer)this.clearThreshold.get();
    }
}

