/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser80;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.redis.configuration.Attribute;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.Element;
import org.infinispan.persistence.redis.configuration.RedisSentinelConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.RedisServerConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfigurationBuilder;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:redis:8.0", root="redis-store"), @Namespace(root="redis-store")})
public final class RedisStoreConfigurationParser80
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REDIS_STORE: {
                this.parseRedisStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRedisStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) throws XMLStreamException {
        RedisStoreConfigurationBuilder builder = new RedisStoreConfigurationBuilder(persistenceBuilder);
        this.parseRedisStoreAttributes(reader, builder);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block5;
                }
                case SENTINEL: {
                    this.parseSentinel(reader, builder.addSentinel());
                    continue block5;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block5;
                }
            }
            Parser80.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseServer(XMLExtendedStreamReader reader, RedisServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block4;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseSentinel(XMLExtendedStreamReader reader, RedisSentinelConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block4;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TIME_BETWEEN_EVICTION_RUNS: {
                    builder.timeBetweenEvictionRuns(Long.parseLong(value));
                    continue block11;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    builder.minEvictableIdleTime(Long.parseLong(value));
                    continue block11;
                }
                case MAX_TOTAL: {
                    builder.maxTotal(Integer.parseInt(value));
                    continue block11;
                }
                case MAX_IDLE: {
                    builder.maxIdle(Integer.parseInt(value));
                    continue block11;
                }
                case MIN_IDLE: {
                    builder.minIdle(Integer.parseInt(value));
                    continue block11;
                }
                case TEST_ON_CREATE: {
                    builder.testOnCreate(Boolean.parseBoolean(value));
                    continue block11;
                }
                case TEST_ON_BORROW: {
                    builder.testOnBorrow(Boolean.parseBoolean(value));
                    continue block11;
                }
                case TEST_ON_RETURN: {
                    builder.testOnReturn(Boolean.parseBoolean(value));
                    continue block11;
                }
                case TEST_ON_IDLE: {
                    builder.testOnIdle(Boolean.parseBoolean(value));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRedisStoreAttributes(XMLExtendedStreamReader reader, RedisStoreConfigurationBuilder builder) throws XMLStreamException {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATABASE: {
                    builder.database(Integer.parseInt(value));
                    continue block9;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block9;
                }
                case TOPOLOGY: {
                    builder.topology(RedisStoreConfiguration.Topology.valueOf(value.toUpperCase()));
                    continue block9;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Integer.parseInt(value));
                    continue block9;
                }
                case CONNECTION_TIMEOUT: {
                    builder.connectionTimeout(Integer.parseInt(value));
                    continue block9;
                }
                case MASTER_NAME: {
                    builder.masterName(value);
                    continue block9;
                }
                case MAX_REDIRECTIONS: {
                    builder.maxRedirections(Integer.parseInt(value));
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

