/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.RedisSentinelConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.RedisServerConfiguration;
import org.infinispan.persistence.redis.configuration.RedisServerConfigurationBuilder;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfigurationChildBuilder;

public final class RedisStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RedisStoreConfiguration, RedisStoreConfigurationBuilder>
implements RedisStoreConfigurationChildBuilder<RedisStoreConfigurationBuilder> {
    private List<RedisServerConfigurationBuilder> servers = new ArrayList<RedisServerConfigurationBuilder>();
    private List<RedisSentinelConfigurationBuilder> sentinels = new ArrayList<RedisSentinelConfigurationBuilder>();
    private final ConnectionPoolConfigurationBuilder connectionPool = new ConnectionPoolConfigurationBuilder(this);

    public RedisStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, RedisStoreConfiguration.attributeDefinitionSet());
    }

    public RedisStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder database(int database) {
        this.attributes.attribute(RedisStoreConfiguration.DATABASE).set((Object)database);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder password(String password) {
        this.attributes.attribute(RedisStoreConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder topology(RedisStoreConfiguration.Topology topology) {
        this.attributes.attribute(RedisStoreConfiguration.TOPOLOGY).set((Object)topology);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.attributes.attribute(RedisStoreConfiguration.CONNECTION_TIMEOUT).set((Object)connectionTimeout);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder socketTimeout(int socketTimeout) {
        this.attributes.attribute(RedisStoreConfiguration.SOCKET_TIMEOUT).set((Object)socketTimeout);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder masterName(String masterName) {
        this.attributes.attribute(RedisStoreConfiguration.MASTER_NAME).set((Object)masterName);
        return this;
    }

    @Override
    public RedisStoreConfigurationBuilder maxRedirections(int maxRedirections) {
        this.attributes.attribute(RedisStoreConfiguration.MAX_REDIRECTIONS).set((Object)maxRedirections);
        return this;
    }

    @Override
    public RedisServerConfigurationBuilder addServer() {
        RedisServerConfigurationBuilder builder = new RedisServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public RedisSentinelConfigurationBuilder addSentinel() {
        RedisSentinelConfigurationBuilder builder = new RedisSentinelConfigurationBuilder(this);
        this.sentinels.add(builder);
        return builder;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    public void validate() {
        super.validate();
        RedisStoreConfiguration.Topology topology = (RedisStoreConfiguration.Topology)((Object)this.attributes.attribute(RedisStoreConfiguration.TOPOLOGY).get());
        String masterName = (String)this.attributes.attribute(RedisStoreConfiguration.MASTER_NAME).get();
        if (topology.equals((Object)RedisStoreConfiguration.Topology.SENTINEL) && (masterName == null || masterName.equals(""))) {
            throw new CacheConfigurationException("master-name must be defined when using a sentinel topology.");
        }
        if (topology.equals((Object)RedisStoreConfiguration.Topology.SENTINEL) && this.sentinels.size() == 0) {
            throw new CacheConfigurationException("At least one sentinel-server must be defined when using a sentinel topology.");
        }
        if (topology.equals((Object)RedisStoreConfiguration.Topology.CLUSTER) && this.servers.size() == 0) {
            throw new CacheConfigurationException("One or more redis-server must be defined when using a cluster topology.");
        }
        if (topology.equals((Object)RedisStoreConfiguration.Topology.SERVER) && this.servers.size() == 0) {
            throw new CacheConfigurationException("A redis-server must be defined when using a server topology.");
        }
    }

    public RedisStoreConfigurationBuilder read(RedisStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        for (RedisServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        for (RedisServerConfiguration server : template.sentinels()) {
            this.addSentinel().host(server.host()).port(server.port());
        }
        return this;
    }

    public RedisStoreConfiguration create() {
        ArrayList<RedisServerConfiguration> redisServers = new ArrayList<RedisServerConfiguration>();
        for (RedisServerConfigurationBuilder server : this.servers) {
            redisServers.add(server.create());
        }
        ArrayList<RedisServerConfiguration> redisSentinels = new ArrayList<RedisServerConfiguration>();
        for (RedisSentinelConfigurationBuilder server : this.sentinels) {
            redisSentinels.add(server.create());
        }
        this.attributes.attribute(RedisStoreConfiguration.SERVERS).set(redisServers);
        this.attributes.attribute(RedisStoreConfiguration.SENTINELS).set(redisSentinels);
        return new RedisStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), this.connectionPool.create());
    }
}

