/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.redis.configuration.AbstractRedisStoreConfigurationChildBuilder;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfigurationBuilder;

public final class ConnectionPoolConfigurationBuilder
extends AbstractRedisStoreConfigurationChildBuilder<RedisStoreConfigurationBuilder>
implements Builder<ConnectionPoolConfiguration> {
    private int maxTotal = -1;
    private int maxIdle = -1;
    private int minIdle = 1;
    private long timeBetweenEvictionRuns = 120000L;
    private long minEvictableIdleTime = 1800000L;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testOnIdle = false;

    ConnectionPoolConfigurationBuilder(RedisStoreConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder timeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minEvictableIdleTime(long minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public ConnectionPoolConfigurationBuilder testOnIdle(boolean testOnIdle) {
        this.testOnIdle = testOnIdle;
        return this;
    }

    public void validate() {
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.maxTotal, this.maxIdle, this.minIdle, this.timeBetweenEvictionRuns, this.minEvictableIdleTime, this.testOnCreate, this.testOnBorrow, this.testOnReturn, this.testOnIdle);
    }

    public Builder<?> read(ConnectionPoolConfiguration template) {
        this.maxTotal = template.maxTotal();
        this.maxIdle = template.maxIdle();
        this.minIdle = template.minIdle();
        this.timeBetweenEvictionRuns = template.timeBetweenEvictionRuns();
        this.minEvictableIdleTime = template.minEvictableIdleTime();
        this.testOnCreate = template.testOnCreate();
        this.testOnBorrow = template.testOnBorrow();
        this.testOnReturn = template.testOnReturn();
        this.testOnIdle = template.testOnIdle();
        return this;
    }
}

