/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    HOST("host"),
    PORT("port"),
    PASSWORD("password"),
    DATABASE("database"),
    TOPOLOGY("topology"),
    TIME_BETWEEN_EVICTION_RUNS("time-between-eviction-runs"),
    MIN_EVICTABLE_IDLE_TIME("min-evictable-idle-time"),
    MAX_TOTAL("max-total"),
    MAX_IDLE("max-idle"),
    MIN_IDLE("min-idle"),
    SOCKET_TIMEOUT("socket-timeout"),
    CONNECTION_TIMEOUT("connection-timeout"),
    MASTER_NAME("master-name"),
    MAX_REDIRECTIONS("max-redirections"),
    TEST_ON_CREATE("test-on-create"),
    TEST_ON_BORROW("test-on-borrow"),
    TEST_ON_RETURN("test-on-return"),
    TEST_ON_IDLE("test-on-idle");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

