/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.util.Iterator;
import java.util.Map;
import org.infinispan.persistence.redis.client.RedisMarshaller;
import org.infinispan.persistence.redis.client.RedisServerKeyIterator;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public final class RedisClusterNodeIterator
implements Iterator<Object> {
    private RedisMarshaller<String> marshaller;
    private Map<String, JedisPool> clusterNodes;
    private Iterator<String> clusterNodeIt;
    private RedisServerKeyIterator keyIterator = null;

    public RedisClusterNodeIterator(JedisCluster cluster, RedisMarshaller<String> marshaller) {
        this.marshaller = marshaller;
        this.clusterNodes = cluster.getClusterNodes();
        this.clusterNodeIt = this.clusterNodes.keySet().iterator();
    }

    @Override
    public boolean hasNext() {
        if (null != this.keyIterator && this.keyIterator.hasNext()) {
            return true;
        }
        Jedis client = null;
        while (this.clusterNodeIt.hasNext()) {
            try {
                if (null != this.keyIterator) {
                    this.keyIterator.release();
                }
                JedisPool pool = this.clusterNodes.get(this.clusterNodeIt.next());
                client = pool.getResource();
                this.keyIterator = new RedisServerKeyIterator(client, this.marshaller);
                if (!this.keyIterator.hasNext()) continue;
                return true;
            }
            catch (Exception ex) {
                if (null != client) {
                    client.close();
                }
                throw ex;
            }
        }
        if (null != this.keyIterator) {
            this.keyIterator.release();
        }
        return false;
    }

    @Override
    public Object next() {
        return this.keyIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

