/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.infinispan.persistence.redis.client.RedisClusterConnection;
import org.infinispan.persistence.redis.client.RedisConnection;
import org.infinispan.persistence.redis.client.RedisConnectionPool;
import org.infinispan.persistence.redis.client.RedisMarshaller;
import org.infinispan.persistence.redis.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.redis.configuration.RedisServerConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public final class RedisClusterConnectionPool
implements RedisConnectionPool {
    private RedisMarshaller<String> marshaller;
    private JedisCluster cluster;

    public RedisClusterConnectionPool(RedisStoreConfiguration configuration, RedisMarshaller<String> marshaller) {
        HashSet<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
        for (RedisServerConfiguration server : configuration.servers()) {
            clusterNodes.add(new HostAndPort(server.host(), server.port()));
        }
        ConnectionPoolConfiguration connectionPoolConfiguration = configuration.connectionPool();
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(connectionPoolConfiguration.maxTotal());
        poolConfig.setMinIdle(connectionPoolConfiguration.minIdle());
        poolConfig.setMaxIdle(connectionPoolConfiguration.maxIdle());
        poolConfig.setMinEvictableIdleTimeMillis(connectionPoolConfiguration.minEvictableIdleTime());
        poolConfig.setTimeBetweenEvictionRunsMillis(connectionPoolConfiguration.timeBetweenEvictionRuns());
        poolConfig.setTestOnCreate(connectionPoolConfiguration.testOnCreate());
        poolConfig.setTestOnBorrow(connectionPoolConfiguration.testOnBorrow());
        poolConfig.setTestOnReturn(connectionPoolConfiguration.testOnReturn());
        poolConfig.setTestWhileIdle(connectionPoolConfiguration.testOnIdle());
        this.cluster = new JedisCluster(clusterNodes, configuration.connectionTimeout(), configuration.socketTimeout(), configuration.maxRedirections(), (GenericObjectPoolConfig)poolConfig);
        this.marshaller = marshaller;
    }

    @Override
    public RedisConnection getConnection() {
        return new RedisClusterConnection(this.cluster, this.marshaller);
    }

    @Override
    public void shutdown() {
        this.cluster.close();
    }
}

