/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.redis.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.infinispan.persistence.redis.client.RedisClusterNodeIterable;
import org.infinispan.persistence.redis.client.RedisConnection;
import org.infinispan.persistence.redis.client.RedisMarshaller;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public final class RedisClusterConnection
implements RedisConnection {
    private JedisCluster cluster;
    private RedisMarshaller<String> marshaller;

    RedisClusterConnection(JedisCluster cluster, RedisMarshaller<String> marshaller) {
        this.cluster = cluster;
        this.marshaller = marshaller;
    }

    @Override
    public void release() {
    }

    @Override
    public Iterable<Object> scan() {
        return new RedisClusterNodeIterable(this.cluster, this.marshaller);
    }

    @Override
    public List<byte[]> hmget(Object key, String ... field) throws IOException, InterruptedException, ClassNotFoundException {
        return this.marshaller.decode(this.cluster.hmget(this.marshaller.marshall(key), field));
    }

    @Override
    public void hmset(Object key, Map<String, byte[]> fields) throws IOException, InterruptedException {
        this.cluster.hmset(this.marshaller.marshall(key), this.marshaller.encode(fields));
    }

    @Override
    public void expire(Object key, int expire) {
        this.cluster.expire(this.marshaller.marshall(key), expire);
    }

    @Override
    public boolean delete(Object key) throws IOException, InterruptedException {
        return this.cluster.del(this.marshaller.marshall(key)) > 0L;
    }

    @Override
    public boolean exists(Object key) throws IOException, InterruptedException {
        return this.cluster.exists(this.marshaller.marshall(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dbSize() {
        long totalSize = 0L;
        Jedis client = null;
        Map clusterNodes = this.cluster.getClusterNodes();
        for (String nodeKey : clusterNodes.keySet()) {
            try {
                client = ((JedisPool)clusterNodes.get(nodeKey)).getResource();
                totalSize += client.dbSize().longValue();
            }
            finally {
                if (null == client) continue;
                client.close();
                client = null;
            }
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushDb() throws IOException, InterruptedException {
        Jedis client = null;
        Map clusterNodes = this.cluster.getClusterNodes();
        for (String nodeKey : clusterNodes.keySet()) {
            try {
                client = ((JedisPool)clusterNodes.get(nodeKey)).getResource();
                client.flushDB();
            }
            finally {
                if (null == client) continue;
                client.close();
                client = null;
            }
        }
    }
}

