/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.loaders.jdbm.configuration.Attribute;
import org.infinispan.loaders.jdbm.configuration.Element;
import org.infinispan.loaders.jdbm.configuration.JdbmCacheStoreConfigurationBuilder;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JdbmCacheStoreConfigurationParser53
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:infinispan:config", "jdbm", Element.JDBM_STORE.getLocalName(), 5, 3), new Namespace("", Element.JDBM_STORE.getLocalName(), 0, 0)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case JDBM_STORE: {
                this.parseJdbmStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseJdbmStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        JdbmCacheStoreConfigurationBuilder builder = new JdbmCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseBdbjeStoreAttributes(reader, builder);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseBdbjeStoreAttributes(XMLExtendedStreamReader reader, JdbmCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case COMPARATOR_CLASS_NAME: {
                    builder.comparatorClassName(value);
                    continue block5;
                }
                case EXPIRY_QUEUE_SIZE: {
                    builder.expiryQueueSize(Integer.parseInt(value));
                    continue block5;
                }
                case LOCATION: {
                    builder.location(value);
                    continue block5;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

