/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.SimpleDateFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.FastIterator;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.htree.HTree;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.jdbm.JdbmCacheStoreConfig;
import org.infinispan.loaders.jdbm.JdbmSerializer;
import org.infinispan.loaders.jdbm.NaturalComparator;
import org.infinispan.loaders.jdbm.logging.Log;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.SysPropertyActions;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@CacheLoaderMetadata(configurationClass=JdbmCacheStoreConfig.class)
public class JdbmCacheStore
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(JdbmCacheStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final String NAME = "CacheLoader";
    private static final String EXPIRY = "Expiry";
    private static final String DATE = "HH:mm:ss.SSS";
    private BlockingQueue<ExpiryEntry> expiryEntryQueue;
    private JdbmCacheStoreConfig config;
    private RecordManager recman;
    private HTree tree;
    private BTree expiryTree;

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return JdbmCacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig clc, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(clc, cache, m);
        this.config = (JdbmCacheStoreConfig)clc;
    }

    public void start() throws CacheLoaderException {
        boolean created;
        String cacheDbName;
        String locationStr = this.config.getLocation();
        if (locationStr == null) {
            locationStr = SysPropertyActions.getProperty((String)"java.io.tmpdir");
            this.config.setLocation(locationStr);
        }
        this.expiryEntryQueue = new LinkedBlockingQueue<ExpiryEntry>(this.config.getExpiryQueueSize());
        int offset = locationStr.indexOf(35);
        if (offset >= 0 && offset < locationStr.length() - 1) {
            cacheDbName = locationStr.substring(offset + 1);
            locationStr = locationStr.substring(0, offset);
        } else {
            cacheDbName = this.cache.getName();
            if (cacheDbName == null) {
                cacheDbName = "jdbm";
            }
        }
        File location = new File(locationStr);
        if (!location.exists() && !(created = location.mkdirs())) {
            throw new ConfigurationException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new ConfigurationException("Cache loader location [" + location + "] is not a directory!");
        }
        try {
            this.openDatabase(new File(location, cacheDbName));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        log.debug("cleaning up expired entries...");
        this.purgeInternal();
        log.debug("started");
        super.start();
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        try {
            InternalCacheEntry ice = this.unmarshall(this.tree.get(key), key);
            if (ice != null && ice.isExpired(System.currentTimeMillis())) {
                this.remove(key);
                return null;
            }
            return ice;
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return new BTreeSet();
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return new BTreeSet(numEntries);
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        try {
            Object o;
            HashSet<Object> s = new HashSet<Object>();
            FastIterator fi = this.tree.keys();
            while ((o = fi.next()) != null) {
                if (keysToExclude != null && keysToExclude.contains(o)) continue;
                s.add(o);
            }
            return s;
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private void openDatabase(File f) throws Exception {
        Properties props = new Properties();
        this.recman = RecordManagerFactory.createRecordManager((String)f.toString(), (Properties)props);
        long recid = this.recman.getNamedObject(NAME);
        log.debugf("%s located as %d", NAME, recid);
        if (recid == 0L) {
            this.createTree();
        } else {
            this.tree = HTree.load((RecordManager)this.recman, (long)recid);
            recid = this.recman.getNamedObject(EXPIRY);
            this.expiryTree = BTree.load((RecordManager)this.recman, (long)recid);
            this.setSerializer();
        }
        log.jdbmDbOpened(f);
    }

    private void setSerializer() {
        this.expiryTree.setValueSerializer((Serializer)new JdbmSerializer(this.getMarshaller()));
    }

    private void createTree() throws IOException {
        this.tree = HTree.createInstance((RecordManager)this.recman);
        this.expiryTree = BTree.createInstance((RecordManager)this.recman, new NaturalComparator(), null, null);
        this.recman.setNamedObject(NAME, this.tree.getRecid());
        this.recman.setNamedObject(EXPIRY, this.expiryTree.getRecid());
        this.setSerializer();
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        if (this.recman != null) {
            try {
                this.recman.close();
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.recman = null;
        this.tree = null;
        this.expiryTree = null;
    }

    public void clear() throws CacheLoaderException {
        if (trace) {
            log.trace("clear()");
        }
        try {
            this.recman.delete(this.tree.getRecid());
            this.recman.delete(this.expiryTree.getRecid());
            this.createTree();
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key) throws CacheLoaderException {
        try {
            boolean bl = this.remove0(key);
            return bl;
        }
        finally {
            this.commit();
        }
    }

    private void commit() throws CacheLoaderException {
        try {
            this.recman.commit();
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public boolean remove0(Object key) throws CacheLoaderException {
        if (trace) {
            log.tracef("remove() %s", key);
        }
        try {
            boolean ret = this.tree.get(key) != null;
            this.tree.remove(key);
            return ret;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        this.store0(entry);
        this.commit();
    }

    private byte[] marshall(InternalCacheEntry entry) throws IOException, InterruptedException {
        return this.getMarshaller().objectToByteBuffer((Object)entry.toInternalCacheValue());
    }

    private InternalCacheEntry unmarshall(Object o, Object key) throws IOException, ClassNotFoundException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        InternalCacheValue v = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b);
        return v.toInternalCacheEntry(key);
    }

    private void store0(InternalCacheEntry entry) throws CacheLoaderException {
        Object key = entry.getKey();
        if (trace) {
            log.tracef("store() %s", key);
        }
        try {
            this.tree.put(key, (Object)this.marshall(entry));
            if (entry.canExpire()) {
                this.addNewExpiry(entry);
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (trace) {
                log.trace("Interrupted while marshalling entry");
            }
            Thread.currentThread().interrupt();
        }
    }

    private void addNewExpiry(InternalCacheEntry entry) throws IOException {
        long expiry = entry.getExpiryTime();
        if (entry.getMaxIdle() > 0L) {
            expiry = entry.getMaxIdle() + System.currentTimeMillis();
        }
        Long at = expiry;
        Object key = entry.getKey();
        if (trace) {
            log.tracef("at %s expire %s", new SimpleDateFormat(DATE).format(new Date(at)), key);
        }
        try {
            this.expiryEntryQueue.put(new ExpiryEntry(at, key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void toStream(ObjectOutput out) throws CacheLoaderException {
        try {
            Set<InternalCacheEntry> loadAll = this.loadAll();
            log.debug("toStream() entries");
            int count = 0;
            for (InternalCacheEntry entry : loadAll) {
                this.getMarshaller().objectToObjectStream((Object)entry, out);
                ++count;
            }
            this.getMarshaller().objectToObjectStream(null, out);
            log.debugf("wrote %d entries", count);
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void fromStream(ObjectInput in) throws CacheLoaderException {
        try {
            log.debug("fromStream()");
            int count = 0;
            while (true) {
                ++count;
                InternalCacheEntry entry = (InternalCacheEntry)this.getMarshaller().objectFromObjectStream(in);
                if (entry == null) break;
                this.store(entry);
            }
            log.debugf("read %d entries", count);
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace("Interrupted while reading from stream");
            }
            Thread.currentThread().interrupt();
        }
    }

    protected void purgeInternal() throws CacheLoaderException {
        log.trace("purgeInternal");
        try {
            this.purgeInternal0();
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private void purgeInternal0() throws Exception {
        Long time;
        ArrayList entries = new ArrayList();
        this.expiryEntryQueue.drainTo(entries);
        for (ExpiryEntry entry : entries) {
            Object existing = this.expiryTree.insert((Object)entry.expiry, entry.key, false);
            if (existing == null) continue;
            if (existing instanceof List) {
                ((List)existing).add(entry.key);
                this.expiryTree.insert((Object)entry.expiry, existing, true);
                continue;
            }
            ArrayList<Object> al = new ArrayList<Object>(2);
            al.add(existing);
            al.add(entry.key);
            this.expiryTree.insert((Object)entry.expiry, al, true);
        }
        TupleBrowser browse = this.expiryTree.browse();
        Tuple tuple = new Tuple();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<Object> keys = new ArrayList<Object>();
        while (browse.getNext(tuple) && (time = (Long)tuple.getKey()) <= System.currentTimeMillis()) {
            times.add(time);
            Object key = tuple.getValue();
            if (key instanceof List) {
                keys.addAll((List)key);
                continue;
            }
            keys.add(key);
        }
        for (Long time2 : times) {
            this.expiryTree.remove((Object)time2);
        }
        if (!keys.isEmpty()) {
            log.debugf("purge (up to) %d entries", keys.size());
        }
        int count = 0;
        long currentTimeMillis = System.currentTimeMillis();
        for (Object e : keys) {
            InternalCacheValue ice;
            byte[] b = (byte[])this.tree.get(e);
            if (b == null || !(ice = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b)).isExpired(currentTimeMillis)) continue;
            this.tree.remove(e);
            ++count;
        }
        if (count != 0) {
            log.debugf("purged %d entries", count);
        }
        this.recman.commit();
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        block5: for (Modification modification : mods) {
            switch (modification.getType()) {
                case STORE: {
                    this.store0(((Store)modification).getStoredEntry());
                    continue block5;
                }
                case CLEAR: {
                    this.clear();
                    continue block5;
                }
                case REMOVE: {
                    this.remove0(((Remove)modification).getKey());
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        this.commit();
    }

    public String toString() {
        BTree et = this.expiryTree;
        int expiry = et == null ? -1 : et.size();
        return "JdbmCacheLoader locationStr=" + this.config.getLocation() + " expirySize=" + expiry;
    }

    private static final class ExpiryEntry {
        private final Long expiry;
        private final Object key;

        private ExpiryEntry(long expiry, Object key) {
            this.expiry = expiry;
            this.key = key;
        }
    }

    private final class BTreeSet
    extends AbstractSet<InternalCacheEntry> {
        int maxSize = -1;

        private BTreeSet(int maxSize) {
            this.maxSize = maxSize;
        }

        private BTreeSet() {
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            FastIterator fi;
            try {
                fi = JdbmCacheStore.this.tree.keys();
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            return new Iterator<InternalCacheEntry>(){
                int entriesReturned = 0;
                InternalCacheEntry current = null;
                boolean next = true;

                @Override
                public boolean hasNext() {
                    if (this.current == null && this.next) {
                        Object key = fi.next();
                        if (key == null) {
                            this.next = false;
                        } else {
                            try {
                                this.current = JdbmCacheStore.this.unmarshall(JdbmCacheStore.this.tree.get(key), key);
                            }
                            catch (IOException e) {
                                throw new CacheException((Throwable)e);
                            }
                            catch (ClassNotFoundException e) {
                                throw new CacheException((Throwable)e);
                            }
                        }
                    }
                    if (this.next && this.entriesReturned >= BTreeSet.this.maxSize && BTreeSet.this.maxSize > -1) {
                        this.next = false;
                    }
                    return this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public InternalCacheEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        ++this.entriesReturned;
                        InternalCacheEntry internalCacheEntry = this.current;
                        return internalCacheEntry;
                    }
                    finally {
                        this.current = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            log.warn("size() should never be called; except for tests");
            int size = 0;
            for (InternalCacheEntry dummy : this) {
                ++size;
            }
            return size;
        }
    }
}

