/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm;

import java.io.IOException;
import jdbm.helper.Serializer;
import org.infinispan.marshall.Marshaller;

public class JdbmSerializer
implements Serializer {
    private transient Marshaller marshaller;

    public JdbmSerializer(Marshaller marshaller) {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        this.marshaller = marshaller;
    }

    public Object deserialize(byte[] buf) throws IOException {
        try {
            return this.marshaller.objectFromByteBuffer(buf);
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public byte[] serialize(Object obj) throws IOException {
        return this.marshaller.objectToByteBuffer(obj);
    }
}

