/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.CDIConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.util.logging.Log;

public abstract class AbstractJdbcStoreConfigurationParser
implements ConfigurationParser {
    protected boolean handleCommonAttributes(ConfigurationReader reader, AbstractJdbcStoreConfigurationBuilder<?, ?> builder, Attribute attribute, String value) {
        switch (attribute) {
            case DIALECT: {
                builder.dialect(DatabaseType.valueOf(value));
                break;
            }
            case DB_MAJOR_VERSION: 
            case DB_MINOR_VERSION: {
                Log.CONFIG.configDeprecated((Enum)attribute);
                break;
            }
            case READ_QUERY_TIMEOUT: {
                builder.readQueryTimeout(Integer.parseInt(value));
                break;
            }
            case WRITE_QUERY_TIMEOUT: {
                builder.writeQueryTimeout(Integer.parseInt(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean handleCommonElement(AbstractJdbcStoreConfigurationBuilder<?, ?> builder, Element element, ConfigurationReader reader) {
        switch (element) {
            case CONNECTION_POOL: {
                this.parseConnectionPoolAttributes(reader, builder.connectionPool());
                break;
            }
            case DATA_SOURCE: {
                this.parseDataSourceAttributes(reader, builder.dataSource());
                break;
            }
            case CDI_DATA_SOURCE: {
                this.parseCDIDataSourceAttributes(reader, builder.cdiDataSource());
                break;
            }
            case SIMPLE_CONNECTION: {
                this.parseSimpleConnectionAttributes(reader, builder.simpleConnection());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void parseDataSourceAttributes(ConfigurationReader reader, ManagedConnectionFactoryConfigurationBuilder<?> builder) {
        String jndiUrl = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (String)Attribute.JNDI_URL.getLocalName());
        builder.jndiUrl(jndiUrl);
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    protected void parseCDIDataSourceAttributes(ConfigurationReader reader, CDIConnectionFactoryConfigurationBuilder<?> builder) {
        ParseUtils.parseAttributes((ConfigurationReader)reader, builder);
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    protected void parseConnectionPoolAttributes(ConfigurationReader reader, PooledConnectionFactoryConfigurationBuilder<?> builder) {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PROPERTIES_FILE: {
                    builder.propertyFile(value);
                    continue block7;
                }
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block7;
                }
                case DRIVER: {
                    builder.driverClass(value);
                    continue block7;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block7;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    protected void parseSimpleConnectionAttributes(ConfigurationReader reader, SimpleConnectionFactoryConfigurationBuilder<?> builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CONNECTION_URL: {
                    builder.connectionUrl(value);
                    continue block6;
                }
                case DRIVER: {
                    builder.driverClass(value);
                    continue block6;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block6;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

