/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.net.URI;
import java.util.ServiceLoader;
import org.infinispan.api.Experimental;
import org.infinispan.api.async.AsyncContainer;
import org.infinispan.api.configuration.Configuration;
import org.infinispan.api.exception.InfinispanConfigurationException;
import org.infinispan.api.mutiny.MutinyContainer;
import org.infinispan.api.sync.SyncContainer;

@Experimental(value="This is not ready yet for general consumption. Major changes are still expected.")
public interface Infinispan
extends AutoCloseable {
    public static Infinispan create(URI uri) {
        for (Factory factory : ServiceLoader.load(Factory.class, Factory.class.getClassLoader())) {
            Infinispan instance = factory.create(uri);
            if (instance == null) continue;
            return instance;
        }
        throw new InfinispanConfigurationException("No factory to handle URI " + uri);
    }

    public static Infinispan create(String uri) {
        return Infinispan.create(URI.create(uri));
    }

    public static Infinispan create(Configuration configuration) {
        for (Factory factory : ServiceLoader.load(Factory.class, Factory.class.getClassLoader())) {
            Infinispan instance = factory.create(configuration);
            if (instance == null) continue;
            return instance;
        }
        throw new InfinispanConfigurationException("No factory to handle configuration " + configuration);
    }

    public SyncContainer sync();

    public AsyncContainer async();

    public MutinyContainer mutiny();

    @Override
    public void close();

    public static interface Factory {
        public Infinispan create(URI var1);

        public Infinispan create(Configuration var1);
    }
}

