/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.List;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;

@Scope(value=Scopes.NAMED_CACHE)
public class AnchorManager {
    @Inject
    DistributionManager distributionManager;

    public Address getCurrentWriter() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        List members = cacheTopology.getReadConsistentHash().getMembers();
        if (members.size() == 1) {
            return null;
        }
        Address newestMember = (Address)members.get(members.size() - 1);
        if (newestMember.equals(cacheTopology.getLocalAddress())) {
            return null;
        }
        return newestMember;
    }

    public boolean isCurrentWriter() {
        return this.getCurrentWriter() == null;
    }

    public Address updateLocation(Address address) {
        if (address != null && this.distributionManager.getCacheTopology().getMembersSet().contains(address)) {
            return address;
        }
        return this.getCurrentWriter();
    }
}

