/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.anchored.configuration.Attribute;
import org.infinispan.anchored.configuration.Element;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;

@Namespaces(value={@Namespace(root="anchored-keys"), @Namespace(uri="urn:infinispan:config:anchored:*", root="anchored-keys", since="11.0")})
public class AnchoredKeysConfigurationParser
implements ConfigurationParser {
    static final String PREFIX = "anchored";
    static final String NAMESPACE = "urn:infinispan:config:anchored:";

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope((Enum)ParserScope.CACHE) && !holder.inScope((Enum)ParserScope.CACHE_TEMPLATE)) {
            throw new IllegalStateException("WRONG SCOPE");
        }
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ANCHORED_KEYS: {
                AnchoredKeysConfigurationBuilder anchoredBuilder = (AnchoredKeysConfigurationBuilder)builder.addModule(AnchoredKeysConfigurationBuilder.class);
                anchoredBuilder.enabled(true);
                this.parseAnchoredKeys(reader, anchoredBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseAnchoredKeys(XMLExtendedStreamReader reader, AnchoredKeysConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.enabled(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

