/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import org.infinispan.anchored.impl.AnchorManager;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
@Scope(value=Scopes.NAMED_CACHE)
public class AnchoredFetchInterceptor
extends BaseRpcInterceptor {
    private static Log log = LogFactory.getLog(AnchoredFetchInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    CommandsFactory cf;
    @Inject
    EntryFactory entryFactory;
    @Inject
    AnchorManager anchorManager;

    protected Log getLog() {
        return log;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        boolean isWrite = false;
        CompletionStage<Void> fetchStage = this.fetchContextValues(ctx, command, isWrite);
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, fetchStage);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        HashMap existingLocations = new HashMap();
        ctx.forEachValue((key, cacheEntry) -> {
            if (cacheEntry.getValue() instanceof Address) {
                existingLocations.put(key, (Address)cacheEntry.getValue());
            }
        });
        return this.invokeNextAndFinally(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> rCtx.forEachValue((key, cacheEntry) -> {
            if (cacheEntry.isChanged()) {
                if (cacheEntry.getValue() instanceof Address) {
                    return;
                }
                Address location = (Address)existingLocations.get(key);
                if (location == null) {
                    location = this.anchorManager.getCurrentWriter();
                }
                if (this.rpcManager.getAddress().equals(location)) {
                    return;
                }
                cacheEntry.setValue((Object)location);
            }
        }));
    }

    private CompletionStage<Void> fetchContextValues(InvocationContext ctx, GetKeyValueCommand command, boolean isWrite) {
        AggregateCompletionStage fetchStage = CompletionStages.aggregateCompletionStage();
        ArrayList stages = new ArrayList(ctx.lookedUpEntriesCount());
        ctx.forEachEntry((key, ctxEntry) -> {
            if (!(ctxEntry.getValue() instanceof Address)) {
                return;
            }
            ClusteredGetCommand getCommand = this.cf.buildClusteredGetCommand(key, command.getSegment(), command.getFlagsBitSet());
            getCommand.setTopologyId(0);
            getCommand.setWrite(isWrite);
            Address realOwner = (Address)ctxEntry.getValue();
            FetchResponseCollector collector = new FetchResponseCollector(key);
            CompletionStage stage = this.rpcManager.invokeCommand(realOwner, (ReplicableCommand)getCommand, (ResponseCollector)collector, this.rpcManager.getSyncRpcOptions());
            stages.add(stage);
            fetchStage.dependsOn(stage);
        });
        return fetchStage.freeze().thenAccept(__ -> {
            for (CompletionStage stage : stages) {
                CacheEntry ownerEntry = (CacheEntry)CompletionStages.join((CompletionStage)stage);
                this.entryFactory.wrapExternalEntry(ctx, ownerEntry.getKey(), ownerEntry, true, isWrite);
            }
        });
    }

    private static class FetchResponseCollector
    extends ValidSingleResponseCollector<CacheEntry<?, ?>> {
        private final Object key;

        public FetchResponseCollector(Object key) {
            this.key = key;
        }

        protected CacheEntry<?, ?> withValidResponse(Address sender, ValidResponse response) {
            Object responseValue = response.getResponseValue();
            if (responseValue == null) {
                return NullCacheEntry.getInstance();
            }
            return ((InternalCacheValue)responseValue).toInternalCacheEntry(this.key);
        }

        protected CacheEntry<?, ?> targetNotFound(Address sender) {
            return null;
        }
    }
}

