/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored;

import org.infinispan.anchored.configuration.AnchoredKeysConfiguration;
import org.infinispan.anchored.impl.AnchorManager;
import org.infinispan.anchored.impl.AnchoredDistributionInterceptor;
import org.infinispan.anchored.impl.AnchoredFetchInterceptor;
import org.infinispan.anchored.impl.AnchoredStateProvider;
import org.infinispan.commons.logging.Log;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.DynamicModuleMetadataProvider;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.interceptors.impl.ClusteringInterceptor;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.statetransfer.StateProvider;

@InfinispanModule(name="anchored-keys", requiredModules={"core"})
public final class AnchoredKeysModuleLifecycle
implements ModuleLifecycle,
DynamicModuleMetadataProvider {
    public static final String ANCHORED_KEYS_FEATURE = "anchored-keys";
    private GlobalConfiguration globalConfiguration;

    public void registerDynamicMetadata(ModuleMetadataBuilder.ModuleBuilder moduleBuilder, GlobalConfiguration globalConfiguration) {
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        AnchoredKeysConfiguration anchoredKeysConfiguration = (AnchoredKeysConfiguration)configuration.module(AnchoredKeysConfiguration.class);
        if (anchoredKeysConfiguration == null || !anchoredKeysConfiguration.enabled()) {
            return;
        }
        assert (configuration.clustering().cacheMode().isReplicated());
        assert (!configuration.clustering().stateTransfer().awaitInitialTransfer());
        if (!this.globalConfiguration.features().isAvailable(ANCHORED_KEYS_FEATURE)) {
            throw Log.CONFIG.featureDisabled(ANCHORED_KEYS_FEATURE);
        }
        cr.registerComponent((Object)new AnchorManager(), AnchorManager.class);
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        interceptorChain.removeInterceptor(ClusteringInterceptor.class);
        AnchoredDistributionInterceptor distInterceptor = new AnchoredDistributionInterceptor();
        cr.registerComponent((Object)distInterceptor, AnchoredDistributionInterceptor.class);
        assert (interceptorChain.addInterceptorBefore((AsyncInterceptor)distInterceptor, CallInterceptor.class));
        AnchoredFetchInterceptor fetchInterceptor = new AnchoredFetchInterceptor();
        cr.registerComponent((Object)fetchInterceptor, AnchoredFetchInterceptor.class);
        assert (interceptorChain.addInterceptorBefore((AsyncInterceptor)fetchInterceptor, CallInterceptor.class));
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        bcr.replaceComponent(StateProvider.class.getName(), (Object)new AnchoredStateProvider(), true);
        cr.rewire();
    }
}

