/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.images;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.images.Util;

@ApplicationScoped
class IdentitiesGenerator {
    IdentitiesGenerator() {
    }

    void process(File identitiesConfig, File outputDir) throws IOException {
        if (identitiesConfig == null) {
            return;
        }
        outputDir.mkdirs();
        Map<String, Object> userConfig = Util.loadYaml(identitiesConfig);
        IdentitiesGenerator.processCredentials((ArrayList)Util.get(userConfig, "credentials"), outputDir);
    }

    static void processCredentials(ArrayList<Map<String, Object>> credentials, File outputDir) throws IOException {
        if (credentials == null) {
            return;
        }
        Properties users = new Properties();
        Properties groups = new Properties();
        for (Map<String, Object> c : credentials) {
            Object username = c.get("username");
            Object password = c.get("password");
            if (username == null || password == null) {
                System.err.println("Credential identities require both a 'username' and 'password'");
                System.exit(1);
            }
            users.put(username, password);
            List roles = (List)c.get("roles");
            if (roles != null) {
                groups.put(username, String.join((CharSequence)",", roles));
            }
            try (FileWriter usersWriter = new FileWriter(new File(outputDir, "users.properties"));
                 FileWriter groupsWriter = new FileWriter(new File(outputDir, "groups.properties"));){
                users.store(usersWriter, "$REALM_NAME=default$");
                groups.store(groupsWriter, null);
            }
        }
    }
}

