/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.debug.InternalDebugControl;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.ClassTracker;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.DeclarationSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Diag;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Eval;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.ExecutionControl;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.ImportSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JDIEnv;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.KeyMap;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.MethodSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.PersistentSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Snippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SnippetEvent;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SnippetMaps;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SourceCodeAnalysis;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SourceCodeAnalysisImpl;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.TaskFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.TypeDeclSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Util;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.VarSnippet;

public class JShell
implements AutoCloseable {
    final SnippetMaps maps;
    final KeyMap keyMap;
    final TaskFactory taskFactory;
    final InputStream in;
    final PrintStream out;
    final PrintStream err;
    final Supplier<String> tempVariableNameGenerator;
    final BiFunction<Snippet, Integer, String> idGenerator;
    private int nextKeyIndex = 1;
    final Eval eval;
    final ClassTracker classTracker;
    private final Map<Subscription, Consumer<JShell>> shutdownListeners = new HashMap<Subscription, Consumer<JShell>>();
    private final Map<Subscription, Consumer<SnippetEvent>> keyStatusListeners = new HashMap<Subscription, Consumer<SnippetEvent>>();
    private boolean closed = false;
    private ExecutionControl executionControl = null;
    private SourceCodeAnalysisImpl sourceCodeAnalysis = null;

    JShell(Builder b) {
        this.in = b.in;
        this.out = b.out;
        this.err = b.err;
        this.tempVariableNameGenerator = b.tempVariableNameGenerator;
        this.idGenerator = b.idGenerator;
        this.maps = new SnippetMaps(this);
        this.maps.setPackageName("REPL");
        this.keyMap = new KeyMap(this);
        this.taskFactory = new TaskFactory(this);
        this.eval = new Eval(this);
        this.classTracker = new ClassTracker(this);
    }

    public static JShell create() {
        return JShell.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public SourceCodeAnalysis sourceCodeAnalysis() {
        if (this.sourceCodeAnalysis == null) {
            this.sourceCodeAnalysis = new SourceCodeAnalysisImpl(this);
        }
        return this.sourceCodeAnalysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnippetEvent> eval(String input) throws IllegalStateException {
        SourceCodeAnalysisImpl a = this.sourceCodeAnalysis;
        if (a != null) {
            a.suspendIndexing();
        }
        try {
            this.checkIfAlive();
            List<SnippetEvent> events = this.eval.eval(input);
            events.forEach(this::notifyKeyStatusEvent);
            List<SnippetEvent> list = Collections.unmodifiableList(events);
            return list;
        }
        finally {
            if (a != null) {
                a.resumeIndexing();
            }
        }
    }

    public List<SnippetEvent> drop(PersistentSnippet snippet) throws IllegalStateException {
        this.checkIfAlive();
        this.checkValidSnippet(snippet);
        List<SnippetEvent> events = this.eval.drop(snippet);
        events.forEach(this::notifyKeyStatusEvent);
        return Collections.unmodifiableList(events);
    }

    public void addToClasspath(String path) {
        this.taskFactory.addToClasspath(path);
        this.executionControl().commandAddToClasspath(path);
        if (this.sourceCodeAnalysis != null) {
            this.sourceCodeAnalysis.classpathChanged();
        }
    }

    public void stop() {
        if (this.executionControl != null) {
            this.executionControl.commandStop();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closeDown();
            this.executionControl().commandExit();
        }
    }

    public List<Snippet> snippets() throws IllegalStateException {
        this.checkIfAlive();
        return Collections.unmodifiableList(this.maps.snippetList());
    }

    public List<VarSnippet> variables() throws IllegalStateException {
        return this.snippets().stream().filter(sn -> this.status((Snippet)sn).isActive && sn.kind() == Snippet.Kind.VAR).map(sn -> (VarSnippet)sn).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<MethodSnippet> methods() throws IllegalStateException {
        return this.snippets().stream().filter(sn -> this.status((Snippet)sn).isActive && sn.kind() == Snippet.Kind.METHOD).map(sn -> (MethodSnippet)sn).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<TypeDeclSnippet> types() throws IllegalStateException {
        return this.snippets().stream().filter(sn -> this.status((Snippet)sn).isActive && sn.kind() == Snippet.Kind.TYPE_DECL).map(sn -> (TypeDeclSnippet)sn).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<ImportSnippet> imports() throws IllegalStateException {
        return this.snippets().stream().filter(sn -> this.status((Snippet)sn).isActive && sn.kind() == Snippet.Kind.IMPORT).map(sn -> (ImportSnippet)sn).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Snippet.Status status(Snippet snippet) {
        return this.checkValidSnippet(snippet).status();
    }

    public List<Diag> diagnostics(Snippet snippet) {
        return Collections.unmodifiableList(this.checkValidSnippet(snippet).diagnostics());
    }

    public List<String> unresolvedDependencies(DeclarationSnippet snippet) {
        return Collections.unmodifiableList(this.checkValidSnippet(snippet).unresolved());
    }

    public String varValue(VarSnippet snippet) throws IllegalStateException {
        this.checkIfAlive();
        this.checkValidSnippet(snippet);
        if (snippet.status() != Snippet.Status.VALID) {
            throw new IllegalArgumentException("Snippet parameter of varValue() '" + snippet + "' must be VALID, it is: " + (Object)((Object)snippet.status()));
        }
        String value = this.executionControl().commandVarValue(this.maps.classFullName(snippet), snippet.name());
        return Util.expunge(value);
    }

    public Subscription onSnippetEvent(Consumer<SnippetEvent> listener) throws IllegalStateException {
        return this.onX(this.keyStatusListeners, listener);
    }

    public Subscription onShutdown(Consumer<JShell> listener) throws IllegalStateException {
        return this.onX(this.shutdownListeners, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Subscription token) {
        JShell jShell = this;
        synchronized (jShell) {
            token.remover.accept(token);
        }
    }

    ExecutionControl executionControl() {
        if (this.executionControl == null) {
            this.executionControl = new ExecutionControl(new JDIEnv(this), this.maps, this);
            try {
                this.executionControl.launch();
            }
            catch (IOException ex) {
                throw new InternalError("Launching JDI execution engine threw: " + ex.getMessage(), ex);
            }
        }
        return this.executionControl;
    }

    void debug(int flags, String format, Object ... args) {
        if (InternalDebugControl.debugEnabled(this, flags)) {
            this.err.printf(format, args);
        }
    }

    void debug(Exception ex, String where) {
        if (InternalDebugControl.debugEnabled(this, -1)) {
            this.err.printf("Fatal error: %s: %s\n", where, ex.getMessage());
            ex.printStackTrace(this.err);
        }
    }

    int nextKeyIndex() {
        return this.nextKeyIndex++;
    }

    private synchronized <T> Subscription onX(Map<Subscription, Consumer<T>> map, Consumer<T> listener) throws IllegalStateException {
        Objects.requireNonNull(listener);
        this.checkIfAlive();
        Subscription token = new Subscription(map::remove);
        map.put(token, listener);
        return token;
    }

    private synchronized void notifyKeyStatusEvent(SnippetEvent event) {
        this.keyStatusListeners.values().forEach(l -> l.accept(event));
    }

    private synchronized void notifyShutdownEvent(JShell state) {
        this.shutdownListeners.values().forEach(l -> l.accept(state));
    }

    void closeDown() {
        if (!this.closed) {
            this.closed = true;
            this.notifyShutdownEvent(this);
        }
    }

    private void checkIfAlive() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("JShell (" + this + ") has been closed.");
        }
    }

    private Snippet checkValidSnippet(Snippet sn) {
        if (sn == null) {
            throw new NullPointerException("Snippet must not be null");
        }
        if (sn.key().state() != this) {
            throw new IllegalArgumentException("Snippet not from this JShell");
        }
        return sn;
    }

    public class Subscription {
        Consumer<Subscription> remover;

        Subscription(Consumer<Subscription> remover) {
            this.remover = remover;
        }
    }

    public static class Builder {
        InputStream in = new ByteArrayInputStream(new byte[0]);
        PrintStream out = System.out;
        PrintStream err = System.err;
        Supplier<String> tempVariableNameGenerator = null;
        BiFunction<Snippet, Integer, String> idGenerator = null;

        Builder() {
        }

        public Builder in(InputStream in) {
            this.in = in;
            return this;
        }

        public Builder out(PrintStream out) {
            this.out = out;
            return this;
        }

        public Builder err(PrintStream err) {
            this.err = err;
            return this;
        }

        public Builder tempVariableNameGenerator(Supplier<String> generator) {
            this.tempVariableNameGenerator = generator;
            return this;
        }

        public Builder idGenerator(BiFunction<Snippet, Integer, String> generator) {
            this.idGenerator = generator;
            return this;
        }

        public JShell build() {
            return new JShell(this);
        }
    }
}

