/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Assert;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.List;

public class ListBuffer<A>
extends AbstractQueue<A> {
    private List<A> elems;
    private List<A> last;
    private int count;
    private boolean shared;

    public static <T> ListBuffer<T> of(T x) {
        ListBuffer<T> lb = new ListBuffer<T>();
        lb.add(x);
        return lb;
    }

    public ListBuffer() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.elems = List.nil();
        this.last = null;
        this.count = 0;
        this.shared = false;
    }

    public int length() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        if (this.elems.nonEmpty()) {
            List<A> orig = this.elems;
            this.last = List.of(orig.head);
            this.elems = this.last;
            while ((orig = orig.tail).nonEmpty()) {
                this.last.tail = List.of(orig.head);
                this.last = this.last.tail;
            }
        }
    }

    public ListBuffer<A> prepend(A x) {
        this.elems = this.elems.prepend(x);
        if (this.last == null) {
            this.last = this.elems;
        }
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A x) {
        Assert.checkNonNull(x);
        if (this.shared) {
            this.copy();
        }
        List<A> newLast = List.of(x);
        if (this.last != null) {
            this.last.tail = newLast;
            this.last = newLast;
        } else {
            this.last = newLast;
            this.elems = this.last;
        }
        ++this.count;
        return this;
    }

    public ListBuffer<A> appendList(List<A> xs) {
        while (xs.nonEmpty()) {
            this.append(xs.head);
            xs = xs.tail;
        }
        return this;
    }

    public ListBuffer<A> appendList(ListBuffer<A> xs) {
        return this.appendList(xs.toList());
    }

    public ListBuffer<A> appendArray(A[] xs) {
        for (A x : xs) {
            this.append(x);
        }
        return this;
    }

    public List<A> toList() {
        this.shared = true;
        return this.elems;
    }

    @Override
    public boolean contains(Object x) {
        return this.elems.contains(x);
    }

    @Override
    public <T> T[] toArray(T[] vec) {
        return this.elems.toArray(vec);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public A first() {
        return this.elems.head;
    }

    public A next() {
        Object x = this.elems.head;
        if (!this.elems.isEmpty()) {
            this.elems = this.elems.tail;
            if (this.elems.isEmpty()) {
                this.last = null;
            }
            --this.count;
        }
        return x;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = ListBuffer.this.elems;
            }

            @Override
            public boolean hasNext() {
                return !this.elems.isEmpty();
            }

            @Override
            public A next() {
                if (this.elems.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object elem = this.elems.head;
                this.elems = this.elems.tail;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        this.append(a);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object x : c) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        for (A a : c) {
            this.append(a);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(A a) {
        this.append(a);
        return true;
    }

    @Override
    public A poll() {
        return this.next();
    }

    @Override
    public A peek() {
        return this.first();
    }

    public A last() {
        return this.last != null ? (A)this.last.head : null;
    }
}

