/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser;

import java.util.HashMap;
import java.util.Map;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.DocCommentParser;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ParserFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.Tokens;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.DCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.DocCommentTable;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.JCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.DiagnosticSource;

public class LazyDocCommentTable
implements DocCommentTable {
    ParserFactory fac;
    DiagnosticSource diagSource;
    Map<JCTree, Entry> table;

    LazyDocCommentTable(ParserFactory fac) {
        this.fac = fac;
        this.diagSource = fac.log.currentSource();
        this.table = new HashMap<JCTree, Entry>();
    }

    @Override
    public boolean hasComment(JCTree tree) {
        return this.table.containsKey(tree);
    }

    @Override
    public Tokens.Comment getComment(JCTree tree) {
        Entry e = this.table.get(tree);
        return e == null ? null : e.comment;
    }

    @Override
    public String getCommentText(JCTree tree) {
        Tokens.Comment c = this.getComment(tree);
        return c == null ? null : c.getText();
    }

    @Override
    public DCTree.DCDocComment getCommentTree(JCTree tree) {
        Entry e = this.table.get(tree);
        if (e == null) {
            return null;
        }
        if (e.tree == null) {
            e.tree = new DocCommentParser(this.fac, this.diagSource, e.comment).parse();
        }
        return e.tree;
    }

    @Override
    public void putComment(JCTree tree, Tokens.Comment c) {
        this.table.put(tree, new Entry(c));
    }

    private static class Entry {
        final Tokens.Comment comment;
        DCTree.DCDocComment tree;

        Entry(Tokens.Comment c) {
            this.comment = c;
        }
    }
}

