/*
 * Decompiled with CFR 0.152.
 */
package org.incava.attest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.incava.attest.Message;
import org.junit.Assert;

public class Assertions {
    public static <T> T assertEqual(T expected, T actual, String name, Object value) {
        return Assertions.assertEqual(expected, actual, Message.of(name, value));
    }

    public static <T> T assertEqual(T expected, T actual, String msg) {
        if (Assertions.areArrays(expected, actual)) {
            Assertions.assertEqual((Object[])expected, (Object[])actual, msg);
            return null;
        }
        Assert.assertEquals((String)msg, expected, actual);
        return actual;
    }

    public static <T> T assertEqual(T expected, T actual, Message msg) {
        if (Assertions.areArrays(expected, actual)) {
            Assertions.assertEqual((Object[])expected, (Object[])actual, msg);
            return null;
        }
        Assert.assertEquals((String)msg.toString(), expected, actual);
        return actual;
    }

    public static <T> T assertEqual(T expected, T actual) {
        if (expected != null && expected.getClass().isArray() && actual != null && actual.getClass().isArray()) {
            Assertions.assertEqual((Object[])expected, (Object[])actual);
            return null;
        }
        Assert.assertEquals(expected, actual);
        return actual;
    }

    public static <T> T[] assertEqual(T[] expected, T[] actual, String msg) {
        Assertions.assertEqual(expected == null ? null : Arrays.asList(expected), actual == null ? null : Arrays.asList(actual), msg);
        return actual;
    }

    public static <T> T[] assertEqual(T[] expected, T[] actual, Message msg) {
        Assertions.assertEqual(expected == null ? null : Arrays.asList(expected), actual == null ? null : Arrays.asList(actual), msg);
        return actual;
    }

    public static <T> T[] assertEqual(T[] expected, T[] actual) {
        Assertions.assertEqual(expected == null ? null : Arrays.asList(expected), actual == null ? null : Arrays.asList(actual));
        return actual;
    }

    public static <T> T assertSame(T expected, T actual) {
        Assert.assertSame(expected, actual);
        return actual;
    }

    public static <T> T assertSame(T expected, T actual, String message) {
        Assert.assertSame((String)message, expected, actual);
        return actual;
    }

    public static <T> T assertNull(T obj, String message) {
        Assert.assertEquals((String)message, (Object)true, (Object)(obj == null ? 1 : 0));
        return obj;
    }

    public static <T> T assertNull(T obj) {
        Assert.assertEquals((Object)true, (Object)(obj == null ? 1 : 0));
        return obj;
    }

    public static <T> T denyNull(T obj, String message) {
        Assert.assertEquals((String)message, (Object)true, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    public static <T> T denyNull(T obj) {
        Assert.assertEquals((Object)true, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    public static <T> T assertNotNull(boolean isExpected, T obj) {
        Assert.assertEquals((Object)isExpected, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    public static <T> T assertNotNull(T obj, String message) {
        Assert.assertEquals((String)message, (Object)true, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    public static <T> T assertNotNull(T obj) {
        Assert.assertEquals((Object)true, (Object)(obj != null ? 1 : 0));
        return obj;
    }

    public static <T> T assertIsNull(boolean isExpected, T obj) {
        Assert.assertEquals((Object)isExpected, (Object)(obj == null ? 1 : 0));
        return obj;
    }

    public static <T> T assertIsNull(T obj, String message) {
        Assert.assertEquals((String)message, (Object)true, (Object)(obj == null ? 1 : 0));
        return obj;
    }

    public static <T> T assertIsNull(T obj) {
        Assert.assertEquals((Object)true, (Object)(obj == null ? 1 : 0));
        return obj;
    }

    public static <C extends Collection<T>, T> C assertEqual(C expected, C actual) {
        String msg;
        if (expected == null) {
            Assert.assertNull(actual);
            return actual;
        }
        Iterator<T> ei = expected.iterator();
        Iterator<T> ai = actual.iterator();
        int idx = 0;
        while (ei.hasNext()) {
            T expObj = ei.next();
            if (ai.hasNext()) {
                T actObj = ai.next();
                Assertions.assertEqual(expObj, actObj, Assertions.message("index", idx));
                continue;
            }
            msg = "expected object " + expObj + " at index " + idx + ", but at the end of the collection";
            Assert.fail((String)msg);
        }
        if (ai.hasNext()) {
            T actObj = ai.next();
            msg = "unexpected object " + actObj + " at index " + idx;
            Assert.fail((String)msg);
        }
        return actual;
    }

    public static <T extends Comparable<T>> int assertCompareTo(int expected, T x, T y) {
        int result = x.compareTo(y);
        int cmp = result == 0 ? 0 : result / Math.abs(result);
        return Assertions.assertEqual(Integer.valueOf(expected), Integer.valueOf(cmp), "x: " + x + "; y: " + y + "; result: " + result);
    }

    public static String toString(String key, Object value) {
        return String.valueOf(key) + " => " + String.valueOf(value);
    }

    public static String message(String key, Object value) {
        return Assertions.toString(key, value);
    }

    public static String message(String key, Object[] ary) {
        return Assertions.toString(key, ary == null ? null : Arrays.asList(ary));
    }

    public static String message(String k1, Object v1, String k2, Object v2) {
        return Assertions.message(k1, v1) + "; " + Assertions.message(k2, v2);
    }

    public static String message(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return Assertions.message(k1, v1, k2, v2) + "; " + Assertions.message(k3, v3);
    }

    public static String message(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return Assertions.message(k1, v1, k2, v2, k3, v3) + "; " + Assertions.message(k4, v4);
    }

    public static Message msg(String key, Object value) {
        return Message.of(key, value);
    }

    public static Message msg(String key, Object[] ary) {
        return Message.of(key, ary);
    }

    public static Message msg(String k1, Object v1, String k2, Object v2) {
        return Message.of(k1, v1, k2, v2);
    }

    public static Message msg(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return Message.of(k1, v1, k2, v2, k3, v3);
    }

    public static Message msg(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return Message.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    private static <T> boolean areArrays(T x, T y) {
        return x != null && x.getClass().isArray() && y != null && y.getClass().isArray();
    }
}

