/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.meta.$Round;
import org.immutables.value.internal.$processor$.meta.$ValueTypeComposer;

@ParametersAreNonnullByDefault
@Immutable
public final class $ImmutableRound
extends $Round {
    private final ProcessingEnvironment processing;
    private final RoundEnvironment round;
    private final $ImmutableSet<TypeElement> annotations;
    private final $ImmutableSet<String> customImmutableAnnotations;
    private final $ValueTypeComposer composer;
    private volatile long lazyInitBitmap;
    private static final long ENVIRONMENT_LAZY_INIT_BIT = 1L;
    private .processor..Proto.Environment environment;

    private $ImmutableRound(ProcessingEnvironment processing, RoundEnvironment round, $ImmutableSet<TypeElement> annotations, $ImmutableSet<String> customImmutableAnnotations) {
        this.processing = processing;
        this.round = round;
        this.annotations = annotations;
        this.customImmutableAnnotations = customImmutableAnnotations;
        this.composer = Objects.requireNonNull(super.composer(), "composer");
    }

    @Override
    public ProcessingEnvironment processing() {
        return this.processing;
    }

    @Override
    public RoundEnvironment round() {
        return this.round;
    }

    public $ImmutableSet<TypeElement> annotations() {
        return this.annotations;
    }

    public $ImmutableSet<String> customImmutableAnnotations() {
        return this.customImmutableAnnotations;
    }

    @Override
    $ValueTypeComposer composer() {
        return this.composer;
    }

    public final $ImmutableRound withProcessing(ProcessingEnvironment value) {
        if (this.processing == value) {
            return this;
        }
        ProcessingEnvironment newValue = Objects.requireNonNull(value, "processing");
        return new $ImmutableRound(newValue, this.round, this.annotations, this.customImmutableAnnotations);
    }

    public final $ImmutableRound withRound(RoundEnvironment value) {
        if (this.round == value) {
            return this;
        }
        RoundEnvironment newValue = Objects.requireNonNull(value, "round");
        return new $ImmutableRound(this.processing, newValue, this.annotations, this.customImmutableAnnotations);
    }

    public final $ImmutableRound withAnnotations(TypeElement ... elements) {
        $ImmutableSet<TypeElement> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableRound(this.processing, this.round, newValue, this.customImmutableAnnotations);
    }

    public final $ImmutableRound withAnnotations(Iterable<? extends TypeElement> elements) {
        if (this.annotations == elements) {
            return this;
        }
        $ImmutableSet<TypeElement> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableRound(this.processing, this.round, newValue, this.customImmutableAnnotations);
    }

    public final $ImmutableRound withCustomImmutableAnnotations(String ... elements) {
        $ImmutableSet<String> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableRound(this.processing, this.round, this.annotations, newValue);
    }

    public final $ImmutableRound withCustomImmutableAnnotations(Iterable<String> elements) {
        if (this.customImmutableAnnotations == elements) {
            return this;
        }
        $ImmutableSet<String> newValue = $ImmutableSet.copyOf(elements);
        return new $ImmutableRound(this.processing, this.round, this.annotations, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof $ImmutableRound && this.equalTo(($ImmutableRound)another);
    }

    private boolean equalTo($ImmutableRound another) {
        return this.processing.equals(another.processing) && this.round.equals(another.round) && this.annotations.equals(another.annotations) && this.customImmutableAnnotations.equals(another.customImmutableAnnotations) && this.composer.equals(another.composer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.processing.hashCode();
        h += (h << 5) + this.round.hashCode();
        h += (h << 5) + this.annotations.hashCode();
        h += (h << 5) + this.customImmutableAnnotations.hashCode();
        h += (h << 5) + this.composer.hashCode();
        return h;
    }

    public String toString() {
        return $MoreObjects.toStringHelper("Round").omitNullValues().add("processing", this.processing).add("round", this.round).add("annotations", this.annotations).add("customImmutableAnnotations", this.customImmutableAnnotations).add("composer", this.composer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public .processor..Proto.Environment environment() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            $ImmutableRound $ImmutableRound = this;
            synchronized ($ImmutableRound) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.environment = Objects.requireNonNull(super.environment(), "environment");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.environment;
    }

    public static $ImmutableRound copyOf($Round instance) {
        if (instance instanceof $ImmutableRound) {
            return ($ImmutableRound)instance;
        }
        return $ImmutableRound.builder().processing(instance.processing()).round(instance.round()).addAllAnnotations(instance.annotations()).addAllCustomImmutableAnnotations(instance.customImmutableAnnotations()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROCESSING = 1L;
        private static final long INIT_BIT_ROUND = 2L;
        private long initBits = 3L;
        @Nullable
        private ProcessingEnvironment processing;
        @Nullable
        private RoundEnvironment round;
        private $ImmutableSet.Builder<TypeElement> annotations = $ImmutableSet.builder();
        private $ImmutableSet.Builder<String> customImmutableAnnotations = $ImmutableSet.builder();

        private Builder() {
        }

        public final Builder processing(ProcessingEnvironment processing) {
            this.checkNotIsSet(this.processingIsSet(), "processing");
            this.processing = Objects.requireNonNull(processing, "processing");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder round(RoundEnvironment round) {
            this.checkNotIsSet(this.roundIsSet(), "round");
            this.round = Objects.requireNonNull(round, "round");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addAnnotations(TypeElement element) {
            this.annotations.add((Object)element);
            return this;
        }

        public final Builder addAnnotations(TypeElement ... elements) {
            this.annotations.add(elements);
            return this;
        }

        public final Builder addAllAnnotations(Iterable<? extends TypeElement> elements) {
            this.annotations.addAll(elements);
            return this;
        }

        public final Builder addCustomImmutableAnnotations(String element) {
            this.customImmutableAnnotations.add((Object)element);
            return this;
        }

        public final Builder addCustomImmutableAnnotations(String ... elements) {
            this.customImmutableAnnotations.add(elements);
            return this;
        }

        public final Builder addAllCustomImmutableAnnotations(Iterable<String> elements) {
            this.customImmutableAnnotations.addAll((Iterable)elements);
            return this;
        }

        public $ImmutableRound build() {
            this.checkRequiredAttributes();
            return new $ImmutableRound(this.processing, this.round, ($ImmutableSet)this.annotations.build(), ($ImmutableSet)this.customImmutableAnnotations.build());
        }

        private boolean processingIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean roundIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Round is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = $Lists.newArrayList();
            if (!this.processingIsSet()) {
                attributes.add("processing");
            }
            if (!this.roundIsSet()) {
                attributes.add("round");
            }
            return "Cannot build Round, some of required attributes are not set " + attributes;
        }
    }
}

