/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Longs;
import org.immutables.value.internal.$processor$.meta.$ValueMirrors;

public class $DefaultLongMirror
implements $ValueMirrors.DefaultLong {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Default.Long";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.ValueMirrors.$DefaultLong";
    private final AnnotationMirror annotationMirror;
    private final long value;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Long";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$DefaultLongMirror> find(Element element) {
        return $DefaultLongMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$DefaultLongMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $DefaultLongMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$DefaultLongMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $DefaultLongMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $DefaultLongMirror from(TypeElement element) {
        return new $DefaultLongMirror(element);
    }

    public static $Optional<$DefaultLongMirror> from(AnnotationMirror mirror) {
        return $DefaultLongMirror.find(Collections.singleton(mirror));
    }

    private $DefaultLongMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        long value = 0L;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Long");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.value = value;
    }

    private $DefaultLongMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        long value = 0L;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Long");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.value = value;
    }

    @Override
    public long value() {
        return this.value;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $ValueMirrors.DefaultLong.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "value".hashCode() ^ $Longs.hashCode(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $DefaultLongMirror) {
            $DefaultLongMirror otherMirror = ($DefaultLongMirror)other;
            return this.value == otherMirror.value;
        }
        return false;
    }

    @Override
    public String toString() {
        return "DefaultLongMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        long value;

        private ValueExtractor() {
        }

        @Override
        public Void visitLong(long value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        long get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.value.Value.Default.Long");
        }
    }
}

