/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.processor.meta.ValueAttribute;

public final class TelescopicBuild {
    public final List<TelescopicStage> stages;
    public final List<ValueAttribute> finals;

    private TelescopicBuild(List<TelescopicStage> initializers, List<ValueAttribute> nonMandatory) {
        this.stages = initializers;
        this.finals = nonMandatory;
    }

    public TelescopicStage firstStage() {
        return this.stages.get(0);
    }

    static TelescopicBuild from(List<ValueAttribute> attributes) {
        ArrayList mandatory = Lists.newArrayList();
        ArrayList finals = Lists.newArrayList();
        for (ValueAttribute a : attributes) {
            if (a.isBuilderParameter) continue;
            if (a.isMandatory()) {
                mandatory.add(a);
                continue;
            }
            finals.add(a);
        }
        LinkedList stages = Lists.newLinkedList();
        if (!mandatory.isEmpty()) {
            Collections.reverse(mandatory);
            TelescopicStage next = null;
            for (ValueAttribute m : mandatory) {
                next = new TelescopicStage(m, next);
                stages.addFirst(next);
            }
        }
        return new TelescopicBuild(stages, finals);
    }

    public static final class TelescopicStage {
        public final ValueAttribute attribute;
        @Nullable
        public final TelescopicStage next;

        TelescopicStage(ValueAttribute attribute, @Nullable TelescopicStage next) {
            this.attribute = attribute;
            this.next = next;
        }
    }
}

