/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.ValueMirrors;

public class ParameterMirror
implements ValueMirrors.Parameter {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Parameter";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.ValueMirrors.Parameter";
    private final AnnotationMirror annotationMirror;
    private final int order;
    private final boolean value;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Parameter";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ParameterMirror> find(Element element) {
        return ParameterMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<ParameterMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new ParameterMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<ParameterMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new ParameterMirror(annotationMirror));
        }
        return builder.build();
    }

    public static ParameterMirror from(TypeElement element) {
        return new ParameterMirror(element);
    }

    public static Optional<ParameterMirror> from(AnnotationMirror mirror) {
        return ParameterMirror.find(Collections.singleton(mirror));
    }

    private ParameterMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        int order = 0;
        boolean value = false;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("order".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Parameter");
                }
                OrderExtractor orderExtractor$ = new OrderExtractor();
                annotationValue$.accept(orderExtractor$, null);
                order = orderExtractor$.get();
                continue;
            }
            if (!"value".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Parameter");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.order = order;
        this.value = value;
    }

    private ParameterMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        int order = 0;
        boolean value = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("order".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'order' attribute of @Parameter");
                }
                OrderExtractor orderExtractor$ = new OrderExtractor();
                annotationValue$.accept(orderExtractor$, null);
                order = orderExtractor$.get();
                continue;
            }
            if (!"value".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Parameter");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.order = order;
        this.value = value;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public boolean value() {
        return this.value;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ValueMirrors.Parameter.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "order".hashCode() ^ Ints.hashCode((int)this.order);
        return h += 127 * "value".hashCode() ^ Booleans.hashCode((boolean)this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ParameterMirror) {
            ParameterMirror otherMirror = (ParameterMirror)other;
            return this.order == otherMirror.order && this.value == otherMirror.value;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ParameterMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ValueExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.value.Value.Parameter");
        }
    }

    private static class OrderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        int value;

        private OrderExtractor() {
        }

        @Override
        public Void visitInt(int value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        int get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'order' in @org.immutables.value.Value.Parameter");
        }
    }
}

