/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.processor.meta.ValueType;

public class CaseStructure {
    public final List<ValueType> implementedTypes;
    public final SetMultimap<String, ValueType> subtypeUsages = HashMultimap.create();
    private final Set<String> implementedTypeNames;
    private final SetMultimap<String, ValueType> subtyping;
    public final Predicate<String> isImplementedType = new Predicate<String>(){

        public boolean apply(String input) {
            return CaseStructure.this.implementedTypeNames.contains(input);
        }
    };
    public final Function<String, Iterable<ValueType>> knownSubtypes = new Function<String, Iterable<ValueType>>(){

        public Iterable<ValueType> apply(@Nullable String typeName) {
            Set subtypes = CaseStructure.this.subtyping.get((Object)typeName);
            CaseStructure.this.subtypeUsages.putAll((Object)typeName, (Iterable)subtypes);
            return subtypes;
        }
    };

    CaseStructure(Iterable<ValueType> types) {
        this.implementedTypes = ImmutableList.copyOf(types);
        this.implementedTypeNames = CaseStructure.buildImplementedTypesSet(this.implementedTypes);
        this.subtyping = CaseStructure.buildSubtyping(this.implementedTypes);
    }

    private static Set<String> buildImplementedTypesSet(List<ValueType> implementationTypes) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ValueType discoveredValue : implementationTypes) {
            builder.add((Object)discoveredValue.typeValue().toString());
        }
        return builder.build();
    }

    private static SetMultimap<String, ValueType> buildSubtyping(List<ValueType> implementationTypes) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (ValueType type : implementationTypes) {
            String abstractValueTypeName = type.typeAbstract().toString();
            builder.put((Object)abstractValueTypeName, (Object)type);
            for (String className : type.getExtendedClassesNames()) {
                if (className.equals(abstractValueTypeName)) continue;
                builder.put((Object)className, (Object)type);
            }
            for (String interfaceName : type.getImplementedInterfacesNames()) {
                if (interfaceName.equals(abstractValueTypeName)) continue;
                builder.put((Object)interfaceName, (Object)type);
            }
        }
        return builder.build();
    }

    public Set<ValueType> knownSubtypesOf(String typeName) {
        return this.subtyping.get((Object)typeName);
    }
}

