/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.immutables.generator.AbstractTemplate;
import org.immutables.generator.AnnotationMirrors;
import org.immutables.generator.Generator;
import org.immutables.generator.Naming;
import org.immutables.generator.SourceExtraction;
import org.immutables.generator.Templates;
import org.immutables.value.processor.encode.BuildMirror;
import org.immutables.value.processor.encode.BuilderMirror;
import org.immutables.value.processor.encode.Code;
import org.immutables.value.processor.encode.CopyMirror;
import org.immutables.value.processor.encode.EncodedElement;
import org.immutables.value.processor.encode.EncodingMirror;
import org.immutables.value.processor.encode.ExposeMirror;
import org.immutables.value.processor.encode.ImplMirror;
import org.immutables.value.processor.encode.InitMirror;
import org.immutables.value.processor.encode.IsInitMirror;
import org.immutables.value.processor.encode.NamingMirror;
import org.immutables.value.processor.encode.OfMirror;
import org.immutables.value.processor.encode.SourceMapper;
import org.immutables.value.processor.encode.StandardNaming;
import org.immutables.value.processor.encode.Type;
import org.immutables.value.processor.encode.TypeExtractor;
import org.immutables.value.processor.meta.Reporter;

@Generator.Template
public abstract class Encodings
extends AbstractTemplate {
    @Generator.Typedef
    Encoding Encoding;
    final Reporter reporter = Reporter.from(this.processing());
    final List<Encoding> encodings = new ArrayList<Encoding>();
    private static final String ENCODE_PACKAGE_PREFIX = "org.immutables.encode.";
    private static final Splitter DOC_COMMENT_LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();

    public abstract Templates.Invokable generate();

    Encodings() {
        for (TypeElement a : this.annotations()) {
            if (!a.getQualifiedName().contentEquals(EncodingMirror.qualifiedName())) continue;
            for (TypeElement t : ElementFilter.typesIn(this.round().getElementsAnnotatedWith(a))) {
                this.encodings.add(new Encoding(t));
            }
        }
    }

    private Iterable<String> annotationsFrom(Element element) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String a = AnnotationMirrors.toCharSequence((AnnotationMirror)annotationMirror).toString();
            if (a.startsWith(ENCODE_PACKAGE_PREFIX, 1)) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private Iterable<String> docFrom(Element element) {
        String docComment = this.processing().getElementUtils().getDocComment(element);
        return docComment == null ? ImmutableList.of() : DOC_COMMENT_LINE_SPLITTER.split((CharSequence)docComment);
    }

    class Encoding {
        private final Type.Factory types = new Type.Producer();
        private final TypeExtractor typesReader;
        private final SourceMapper sourceMapper;
        private final Set<String> memberNames = new HashSet<String>();
        final String name;
        final String $$package;
        List<String> typeParams = new ArrayList<String>();
        @Nullable
        EncodedElement impl;
        @Nullable
        EncodedElement toString;
        @Nullable
        EncodedElement hashCode;
        @Nullable
        EncodedElement equals;
        @Nullable
        EncodedElement from;
        @Nullable
        EncodedElement isInit;
        @Nullable
        EncodedElement build;
        final List<EncodedElement> fields = new ArrayList<EncodedElement>();
        final List<EncodedElement> expose = new ArrayList<EncodedElement>();
        final List<EncodedElement> copy = new ArrayList<EncodedElement>();
        final List<EncodedElement> helpers = new ArrayList<EncodedElement>();
        final List<EncodedElement> builderFields = new ArrayList<EncodedElement>();
        final List<EncodedElement> builderInits = new ArrayList<EncodedElement>();
        final List<EncodedElement> builderHelpers = new ArrayList<EncodedElement>();
        final Linkage linkage;
        final SourceExtraction.Imports imports;
        final Iterable<EncodedElement> allElements;
        final Set<String> generatedImports;
        private final Type encodingSelfType;
        private String builderInitCopy;
        final TypeElement typeEncoding;
        @Nullable
        private TypeElement typeBuilder;

        Encoding(TypeElement type) {
            this.typeEncoding = type;
            if (type.getKind() != ElementKind.CLASS || type.getNestingKind() != NestingKind.TOP_LEVEL) {
                Encodings.this.reporter.withElement(type).error("Encoding type '%s' should be top-level class", type.getSimpleName());
            }
            this.$$package = Encodings.this.processing().getElementUtils().getPackageOf(type).getQualifiedName().toString();
            this.name = type.getSimpleName().toString();
            CharSequence source = SourceExtraction.extract((ProcessingEnvironment)Encodings.this.processing(), (TypeElement)type);
            if (source.length() == 0) {
                Encodings.this.reporter.withElement(type).error("No source code can be extracted for @Encoding class. Unsupported compilation mode", new Object[0]);
            }
            this.imports = SourceExtraction.importsFrom((CharSequence)source);
            this.sourceMapper = new SourceMapper(source);
            this.typesReader = new TypeExtractor(this.types, type);
            this.encodingSelfType = this.typesReader.get(type.asType());
            this.addTypeParameters(type);
            for (Element element : type.getEnclosedElements()) {
                this.processMember(element);
            }
            if (this.postValidate()) {
                this.provideSyntheticElements();
            }
            this.allElements = Iterables.concat(Arrays.asList(Iterables.filter(Arrays.asList(this.impl, this.from, this.toString, this.hashCode, this.equals, this.build, this.isInit), (Predicate)Predicates.notNull()), this.fields, this.expose, this.copy, this.helpers, this.builderFields, this.builderHelpers, this.builderInits));
            this.linkage = new Linkage();
            this.generatedImports = this.generatedImports();
        }

        private boolean postValidate() {
            if (this.impl == null) {
                Encodings.this.reporter.withElement(this.typeEncoding).error("@Encoding.Impl field is bare minimum to be declared. Please add implementation field declaration", new Object[0]);
                return false;
            }
            if (this.isPrimitiveExpose() && (this.toString == null || this.hashCode == null || this.equals == null)) {
                Encodings.this.reporter.withElement(this.typeEncoding).error("Encoding implemented or exposed via primitive type must define explicitly encoded 'toString', 'hashCode' and 'equals'. For reference types default routines are assumed via Object.toString(), Object.hashCode() and Object.equals()", new Object[0]);
                return false;
            }
            for (EncodedElement e : this.copy) {
                if (e.type().equals(this.impl.type())) continue;
                Encodings.this.reporter.withElement(this.findEnclosedByName(this.typeEncoding, e.name())).error("@Encoding.Copy method '%s' return type does not match @Encoding.Impl field type. Please, declare it to return: %s", e.name(), this.impl.type());
            }
            if (this.typeBuilder != null) {
                if (this.build != null) {
                    if (!this.build.type().equals(this.impl.type())) {
                        Encodings.this.reporter.withElement(this.findEnclosedByName(this.typeBuilder, this.build.name())).warning("@Encoding.Build method '%s' return type does not match @Encoding.Impl field type. Please, declare it to return: %s", this.build.name(), this.impl.type());
                    }
                } else {
                    Encodings.this.reporter.withElement(this.typeBuilder).error("@Encoding.Builder must have no arg method @Encoding.Build. It is used to describe how to get built fully built instance", new Object[0]);
                }
                if (this.builderInitCopy == null) {
                    Encodings.this.reporter.withElement(this.typeBuilder).error("One of builder init methods should be a copy method, i.e. it should be annotated @Encoding.Init @Encoding.Copy and be able to accept values of type which exposed accessor returns", new Object[0]);
                    return false;
                }
            }
            return true;
        }

        private boolean isPrimitiveExpose() {
            if (!this.expose.isEmpty()) {
                for (EncodedElement e : this.expose) {
                    if (!(e.type() instanceof Type.Primitive)) continue;
                    return true;
                }
            } else if (this.impl.type() instanceof Type.Primitive) {
                return true;
            }
            return false;
        }

        private Element findEnclosedByName(Element enclosing, String name) {
            for (Element element : enclosing.getEnclosedElements()) {
                if (!element.getSimpleName().contentEquals(name)) continue;
                return element;
            }
            throw new NoSuchElementException("No enclosed element named '" + name + "' found in " + enclosing);
        }

        private Set<String> generatedImports() {
            LinkedHashSet<String> lines = new LinkedHashSet<String>();
            for (String a : this.imports.all) {
                if (a.contains(Encodings.ENCODE_PACKAGE_PREFIX) || !a.startsWith("static ") && !a.endsWith(".*")) continue;
                lines.add(a);
            }
            return lines;
        }

        private void addTypeParameters(TypeElement type) {
            for (String n : this.typesReader.parameters.names()) {
                Type.Variable v = this.typesReader.parameters.variable(n);
                if (!v.isUnbounded()) {
                    Encodings.this.reporter.withElement(type).warning("Encoding type '%s' has type parameter <%s extends %s> and it's bounds will be ignored as they are not yet adequately supported or ever will", type.getSimpleName(), v.name, v.upperBounds);
                }
                this.typeParams.add(n);
            }
        }

        private void processMember(Element member) {
            if (!(member.getKind() != ElementKind.FIELD && member.getKind() != ElementKind.METHOD || this.memberNames.add(this.memberPath(member)))) {
                Encodings.this.reporter.withElement(member).error("Duplicate member name '%s'. Encoding has limitation so that any duplicate method names are not supported, even when allowed by JLS: methods cannot have overloads here. @Encoding.Naming annotation could be used so that actually generated methods might have the same name if they are not conflicting as per JLS overload rules", member.getSimpleName());
                return;
            }
            if (member.getKind() == ElementKind.FIELD && this.processField((VariableElement)member)) {
                return;
            }
            if (member.getKind() == ElementKind.METHOD) {
                if (!Ascii.isLowerCase((char)member.getSimpleName().charAt(0))) {
                    Encodings.this.reporter.withElement(member).warning("Methods not starting with lowercase ascii letter might not work properly", member.getSimpleName());
                }
                if (this.processMethod((ExecutableElement)member)) {
                    return;
                }
            }
            if (member.getKind() == ElementKind.CLASS && this.processClass((TypeElement)member)) {
                return;
            }
            if (member.getKind() == ElementKind.INSTANCE_INIT) {
                return;
            }
            if (member.getSimpleName().contentEquals("<init>")) {
                return;
            }
            Encodings.this.reporter.withElement(member).warning("Unrecognized encoding member '%s' will be ignored", member.getSimpleName());
        }

        private boolean processField(VariableElement field) {
            if (ImplMirror.isPresent(field)) {
                return this.processImplField(field);
            }
            return this.processAuxField(field);
        }

        private boolean processAuxField(VariableElement field) {
            List<Code.Term> expression = this.sourceMapper.getExpression(this.memberPath(field));
            if (expression.isEmpty() || !field.getModifiers().contains((Object)Modifier.FINAL)) {
                Encodings.this.reporter.withElement(field).error("Auxiliary field '%s' have to be final and initialized to some value, possibly derived from @Encoding.Impl field (if it's not static)", field.getSimpleName());
                return true;
            }
            if (NamingMirror.isPresent(field)) {
                Encodings.this.reporter.withElement(field).annotationNamed(NamingMirror.simpleName()).warning("Auxiliary field '%s' have naming annotation which is ignored, a field name is always directly derived from the attribute name", field.getSimpleName());
            }
            EnumSet<EncodedElement.Tag> tags = EnumSet.of(EncodedElement.Tag.FIELD);
            AtomicReference<StandardNaming> standardNaming = new AtomicReference<StandardNaming>(StandardNaming.NONE);
            this.fields.add(new EncodedElement.Builder().name(field.getSimpleName().toString()).type(this.typesReader.get(field.asType())).naming(this.inferNaming(field, tags, standardNaming)).standardNaming(standardNaming.get()).typeParameters(this.typesReader.parameters).addAllTags(this.inferTags(field, tags)).addAllDoc(Encodings.this.docFrom(field)).addAllAnnotations(Encodings.this.annotationsFrom(field)).addAllCode(expression).build());
            return true;
        }

        private boolean processImplField(VariableElement field) {
            boolean virtual = ((ImplMirror)ImplMirror.find(field).get()).virtual();
            if (this.impl != null) {
                Encodings.this.reporter.withElement(field).error("@Encoding.Impl duplicate field '%s'. Cannot have more than one implementation field", field.getSimpleName());
                return true;
            }
            if (field.getModifiers().contains((Object)Modifier.STATIC)) {
                Encodings.this.reporter.withElement(field).error("@Encoding.Impl field '%s' cannot be static", field.getSimpleName());
                return true;
            }
            if (!field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                Encodings.this.reporter.withElement(field).error("@Encoding.Impl field '%s' must be private. Other auxiliary fields may be of whatever visibility, but primary implementation field should be private", field.getSimpleName());
                return true;
            }
            if (NamingMirror.isPresent(field)) {
                Encodings.this.reporter.withElement(field).annotationNamed(NamingMirror.simpleName()).warning("@Encoding.Impl field '%s' have naming annotation which is ignored, a field name is always directly derived from the attribute name", field.getSimpleName());
            }
            this.impl = new EncodedElement.Builder().name(field.getSimpleName().toString()).type(this.typesReader.get(field.asType())).addTags(EncodedElement.Tag.IMPL, EncodedElement.Tag.FINAL, EncodedElement.Tag.PRIVATE, virtual ? EncodedElement.Tag.VIRTUAL : EncodedElement.Tag.FIELD).naming(Naming.identity()).typeParameters(this.typesReader.parameters).addAllDoc(Encodings.this.docFrom(field)).addAllAnnotations(Encodings.this.annotationsFrom(field)).addAllCode(this.sourceMapper.getExpression(this.memberPath(field))).build();
            return true;
        }

        private boolean processMethod(ExecutableElement method) {
            if (method.getSimpleName().contentEquals("toString")) {
                return this.processToStringMethod(method);
            }
            if (method.getSimpleName().contentEquals("hashCode")) {
                return this.processHashCodeMethod(method);
            }
            if (method.getSimpleName().contentEquals("equals")) {
                return this.processEqualsMethod(method);
            }
            if (ExposeMirror.isPresent(method)) {
                return this.processExposeMethod(method);
            }
            if (CopyMirror.isPresent(method)) {
                return this.processCopyMethod(method);
            }
            if (OfMirror.isPresent(method)) {
                return this.processFromMethod(method);
            }
            return this.processHelperMethod(method);
        }

        private boolean processHelperMethod(ExecutableElement method) {
            return this.processGenericEncodedMethod(method, this.helpers, EncodedElement.Tag.HELPER);
        }

        private boolean processCopyMethod(ExecutableElement method) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Copy method '%s' cannot be static", method.getSimpleName());
                return true;
            }
            if (this.impl != null && !this.typesReader.get(method.getReturnType()).equals(this.impl.type())) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Copy method '%s' should be declared to return implementation field's type", method.getSimpleName());
            }
            return this.processGenericEncodedMethod(method, this.copy, EncodedElement.Tag.COPY);
        }

        private boolean processFromMethod(ExecutableElement method) {
            if (this.from != null) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Of duplicate method '%s'. Cannot have more than one init method", method.getSimpleName());
                return true;
            }
            if (!this.typeParams.equals(this.getTypeParameterNames(method)) || !method.getModifiers().contains((Object)Modifier.STATIC)) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Of method '%s' should be static with the same type parameters as encoding type: %s", method.getSimpleName(), this.typesReader.parameters);
                return true;
            }
            if (method.getParameters().size() != 1) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Of method '%s' should take a single parameter return type assignable to implementation field", method.getSimpleName());
                return true;
            }
            VariableElement parameter = method.getParameters().get(0);
            if (!method.getThrownTypes().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Of method '%s' cannot have throws declaration", method.getSimpleName());
                return true;
            }
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("@Encoding.Of method '%s' have naming annotation which is ignored. Init is not exposed as a standalone method", method.getSimpleName());
            }
            this.from = new EncodedElement.Builder().name(method.getSimpleName().toString()).type(this.typesReader.get(method.getReturnType())).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.FROM, EncodedElement.Tag.STATIC).naming(this.helperNaming(method.getSimpleName())).addParams(EncodedElement.Param.of(parameter.getSimpleName().toString(), this.typesReader.get(parameter.asType()))).typeParameters(this.typesReader.parameters).addAllDoc(Encodings.this.docFrom(method)).addAllAnnotations(Encodings.this.annotationsFrom(method)).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build();
            return true;
        }

        private boolean processEqualsMethod(ExecutableElement method) {
            if (method.getParameters().size() != 1) {
                return false;
            }
            VariableElement parameter = method.getParameters().get(0);
            if (this.typesReader.get(method.getReturnType()) != Type.Primitive.BOOLEAN || !this.typesReader.get(parameter.asType()).equals(this.encodingSelfType)) {
                Encodings.this.reporter.withElement(method).error("method '%s' should take a single parameter of encoding type %s and return boolean", method.getSimpleName(), this.encodingSelfType);
                return true;
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                Encodings.this.reporter.withElement(method).error("method '%s' cannot be static", method.getSimpleName());
                return true;
            }
            if (!method.getTypeParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("method '%s' cannot have type parameters", method.getSimpleName());
                return true;
            }
            if (!method.getThrownTypes().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("method '%s' cannot have throws declaration", method.getSimpleName());
                return true;
            }
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("method '%s' have naming annotation which is ignored, it is used as part of generated equals()", method.getSimpleName());
            }
            this.equals = new EncodedElement.Builder().name(method.getSimpleName().toString()).type(Type.Primitive.BOOLEAN).addParams(EncodedElement.Param.of(parameter.getSimpleName().toString(), this.encodingSelfType)).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.EQUALS).naming(this.helperNaming(method.getSimpleName())).typeParameters(this.typesReader.parameters).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build();
            return true;
        }

        private boolean processHashCodeMethod(ExecutableElement method) {
            if (!method.getParameters().isEmpty()) {
                return false;
            }
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("method '%s' have naming annotation which is ignored, it is used as part of generated hashCode()", method.getSimpleName());
            }
            this.hashCode = new EncodedElement.Builder().name(method.getSimpleName().toString()).type(Type.Primitive.INT).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.HASH_CODE).naming(this.helperNaming(method.getSimpleName())).typeParameters(this.typesReader.parameters).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build();
            return true;
        }

        private boolean processToStringMethod(ExecutableElement method) {
            if (!method.getParameters().isEmpty()) {
                return false;
            }
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("method '%s' have naming annotation which is ignored, it is used as part of generated toString()", method.getSimpleName());
            }
            this.toString = new EncodedElement.Builder().name(method.getSimpleName().toString()).type(Type.Reference.STRING).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.TO_STRING).naming(this.helperNaming(method.getSimpleName())).typeParameters(this.typesReader.parameters).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build();
            return true;
        }

        private boolean processExposeMethod(ExecutableElement method) {
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("@Encoding.Expose method '%s' have naming annotation which is ignored, an accessor name is configured using @Value.Style(get) patterns", method.getSimpleName());
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Expose method '%s' cannot be static", method.getSimpleName());
                return true;
            }
            if (!method.getTypeParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Expose method '%s' cannot have type parameters", method.getSimpleName());
                return true;
            }
            if (!method.getThrownTypes().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Expose method '%s' cannot have throws declaration", method.getSimpleName());
                return true;
            }
            if (!method.getParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Expose method '%s' must have not parameters and should only access fields", method.getSimpleName());
                return true;
            }
            this.expose.add(new EncodedElement.Builder().name(method.getSimpleName().toString()).type(this.typesReader.get(method.getReturnType())).addTags(EncodedElement.Tag.EXPOSE).naming(Naming.identity()).typeParameters(this.typesReader.parameters).addAllDoc(Encodings.this.docFrom(method)).addAllAnnotations(Encodings.this.annotationsFrom(method)).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build());
            return true;
        }

        private boolean processGenericEncodedMethod(ExecutableElement method, List<EncodedElement> collection, EncodedElement.Tag ... additionalTags) {
            EncodedElement.Builder builder = new EncodedElement.Builder();
            TypeExtractor typesReader = this.processTypeParameters(method, builder);
            AtomicReference<StandardNaming> standardNaming = new AtomicReference<StandardNaming>(StandardNaming.NONE);
            EnumSet<EncodedElement.Tag> tags = EnumSet.noneOf(EncodedElement.Tag.class);
            for (EncodedElement.Tag t : additionalTags) {
                tags.add(t);
            }
            collection.add(builder.name(method.getSimpleName().toString()).type(typesReader.get(method.getReturnType())).naming(this.inferNaming(method, tags, standardNaming)).standardNaming(standardNaming.get()).addAllTags(this.inferTags(method, tags)).addAllParams(this.getParameters(typesReader, method)).addAllDoc(Encodings.this.docFrom(method)).addAllAnnotations(Encodings.this.annotationsFrom(method)).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).addAllThrown((Iterable<? extends Type>)typesReader.getDefined(method.getThrownTypes())).build());
            return true;
        }

        private TypeExtractor processTypeParameters(ExecutableElement method, EncodedElement.Builder builder) {
            boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            TypeExtractor typesReader = isStatic ? new TypeExtractor(this.types, method) : this.typesReader;
            for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
                String name = typeParameterElement.getSimpleName().toString();
                ImmutableList<Type.Defined> bounds = typesReader.getDefined(typeParameterElement.getBounds());
                if (!isStatic) {
                    typesReader = typesReader.withParameter(name, (Iterable<? extends Type.Defined>)bounds);
                }
                builder.addTypeParams(new EncodedElement.TypeParam.Builder().name(name).addAllBounds((Iterable<? extends Type.Defined>)bounds).build());
            }
            builder.typeParameters(typesReader.parameters);
            return typesReader;
        }

        private List<EncodedElement.Param> getParameters(final TypeExtractor typesReader, ExecutableElement method) {
            ArrayList<EncodedElement.Param> result = new ArrayList<EncodedElement.Param>();
            for (VariableElement variableElement : method.getParameters()) {
                result.add(EncodedElement.Param.of(variableElement.getSimpleName().toString(), typesReader.get(variableElement.asType())));
            }
            if (!result.isEmpty() && method.isVarArgs()) {
                EncodedElement.Param last = (EncodedElement.Param)Iterables.getLast(result);
                Type type = last.type().accept(new Type.Transformer(){

                    @Override
                    public Type array(Type.Array array) {
                        return typesReader.factory.varargs(array.element);
                    }
                });
                result.set(result.size() - 1, EncodedElement.Param.of(last.name(), type));
            }
            return result;
        }

        private Naming helperNaming(CharSequence encodedName) {
            return Naming.from((String)("*_" + encodedName));
        }

        private Naming inferNaming(Element element, EnumSet<EncodedElement.Tag> tags, AtomicReference<StandardNaming> standardNaming) {
            Optional<NamingMirror> namingAnnotation = NamingMirror.find(element);
            if (namingAnnotation.isPresent()) {
                try {
                    NamingMirror mirror = (NamingMirror)namingAnnotation.get();
                    Naming naming = Naming.from((String)mirror.value());
                    if (mirror.depluralize()) {
                        tags.add(EncodedElement.Tag.DEPLURALIZE);
                    }
                    standardNaming.set(mirror.standard());
                    return naming;
                }
                catch (IllegalArgumentException ex) {
                    Encodings.this.reporter.withElement(element).annotationNamed(NamingMirror.simpleName()).error(ex.getMessage(), new Object[0]);
                }
            }
            if (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.METHOD && (element.getModifiers().contains((Object)Modifier.PRIVATE) || tags.contains((Object)EncodedElement.Tag.PRIVATE))) {
                return this.helperNaming(element.getSimpleName());
            }
            if (tags.contains((Object)EncodedElement.Tag.INIT) || tags.contains((Object)EncodedElement.Tag.COPY)) {
                return Naming.identity();
            }
            String encodedMethodName = element.getSimpleName().toString();
            return Naming.from((String)("*" + Naming.Usage.CAPITALIZED.apply(encodedMethodName)));
        }

        private String memberPath(Element member) {
            LinkedList<String> names = new LinkedList<String>();
            Element e = member;
            while (e.getKind() != ElementKind.PACKAGE) {
                names.addFirst(e.getSimpleName().toString());
                e = e.getEnclosingElement();
            }
            String path = Joiner.on((char)'.').join(names);
            String suffix = member.getKind() == ElementKind.METHOD ? "()" : "";
            return path + suffix;
        }

        private boolean processClass(TypeElement type) {
            if (BuilderMirror.isPresent(type)) {
                this.typeBuilder = type;
                if (!this.typeParams.equals(this.getTypeParameterNames(type)) || !type.getModifiers().contains((Object)Modifier.STATIC)) {
                    Encodings.this.reporter.withElement(type).error("@Encoding.Builder class '%s' should be static with the same type parameters as encoding type: %s", type.getSimpleName(), this.typesReader.parameters);
                    return true;
                }
                for (Element element : type.getEnclosedElements()) {
                    if (!(element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD || this.memberNames.add(this.memberPath(element)))) {
                        Encodings.this.reporter.withElement(element).error(this.memberPath(element) + ": Duplicate builder member name '%s'. Encoding has limitation so that any duplicate method names are not supported, even when allowed by JLS: methods cannot have overloads here. @Encoding.Naming annotation could be used so that actually generated methods might have the same name if they are not conflicting as per JLS overload rules", element.getSimpleName());
                        continue;
                    }
                    if (element.getKind() == ElementKind.FIELD && this.processBuilderField((VariableElement)element) || element.getKind() == ElementKind.METHOD && this.processBuilderMethod((ExecutableElement)element) || element.getKind() == ElementKind.INSTANCE_INIT || element.getSimpleName().contentEquals("<init>")) continue;
                    Encodings.this.reporter.withElement(element).warning("Unrecognized Builder member '%s' will be ignored", element.getSimpleName());
                }
                return true;
            }
            return false;
        }

        private boolean processBuilderField(VariableElement field) {
            if (NamingMirror.isPresent(field)) {
                Encodings.this.reporter.withElement(field).annotationNamed(NamingMirror.simpleName()).warning("@Enclosing.Builder field '%s' have naming annotation which is ignored, an builder field name is derived automatically", field.getSimpleName());
            }
            EnumSet<EncodedElement.Tag> tags = EnumSet.of(EncodedElement.Tag.FIELD, EncodedElement.Tag.BUILDER);
            AtomicReference<StandardNaming> standardNaming = new AtomicReference<StandardNaming>(StandardNaming.NONE);
            this.builderFields.add(new EncodedElement.Builder().name(field.getSimpleName().toString()).type(this.typesReader.get(field.asType())).naming(this.inferNaming(field, tags, standardNaming)).standardNaming(standardNaming.get()).typeParameters(this.typesReader.parameters).addAllTags(this.inferTags(field, tags)).addAllDoc(Encodings.this.docFrom(field)).addAllAnnotations(Encodings.this.annotationsFrom(field)).addAllCode(this.sourceMapper.getExpression(this.memberPath(field))).build());
            return true;
        }

        private boolean processBuilderMethod(ExecutableElement method) {
            if (BuildMirror.isPresent(method)) {
                return this.processBuilderBuildMethod(method);
            }
            if (IsInitMirror.isPresent(method)) {
                return this.processBuilderIsInitMethod(method);
            }
            if (InitMirror.isPresent(method) || CopyMirror.isPresent(method)) {
                return this.processBuilderInitMethod(method);
            }
            return this.processBuilderHelperMethod(method);
        }

        private boolean processBuilderBuildMethod(ExecutableElement method) {
            if (NamingMirror.isPresent(method)) {
                Encodings.this.reporter.withElement(method).annotationNamed(NamingMirror.simpleName()).warning("@Encoding.Build method '%s' have naming annotation which is ignored. This method is used internally to build instances", method.getSimpleName());
            }
            if (!method.getTypeParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Build method '%s' cannot have type parameters", method.getSimpleName());
                return true;
            }
            if (!method.getThrownTypes().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Build method '%s' cannot have throws declaration", method.getSimpleName());
                return true;
            }
            if (!method.getParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Build method '%s' cannot have parameters", method.getSimpleName());
                return true;
            }
            EnumSet<EncodedElement.Tag> tags = EnumSet.of(EncodedElement.Tag.BUILDER, EncodedElement.Tag.BUILD, EncodedElement.Tag.PRIVATE);
            AtomicReference<StandardNaming> standardNaming = new AtomicReference<StandardNaming>(StandardNaming.NONE);
            this.build = new EncodedElement.Builder().name(method.getSimpleName().toString()).type(this.typesReader.get(method.getReturnType())).naming(this.inferNaming(method, tags, standardNaming)).standardNaming(standardNaming.get()).typeParameters(this.typesReader.parameters).addAllTags(tags).addAllDoc(Encodings.this.docFrom(method)).addAllAnnotations(Encodings.this.annotationsFrom(method)).addAllCode(this.sourceMapper.getBlock(this.memberPath(method))).build();
            return true;
        }

        private boolean processBuilderInitMethod(ExecutableElement method) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Init method '%s' cannot be private", method.getSimpleName());
                return true;
            }
            if (this.typesReader.get(method.getReturnType()) != Type.Primitive.VOID) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Init method '%s' should be declared void. During instantiation, void return type will be replaced with builder type and 'return this' used for chained invokation", method.getSimpleName());
                return true;
            }
            if (!method.getTypeParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.Init method '%s' cannot have type parameters", method.getSimpleName());
                return true;
            }
            EncodedElement.Tag[] additionalTags = new EncodedElement.Tag[]{EncodedElement.Tag.INIT, EncodedElement.Tag.BUILDER};
            if (CopyMirror.isPresent(method)) {
                if (this.builderInitCopy != null) {
                    Encodings.this.reporter.withElement(method).error("@Encoding.Copy method '%s' is duplicating another builder copy method '%s'. There should be only one builder initializer defined as copy-initializer", method.getSimpleName(), this.builderInitCopy);
                    return true;
                }
                this.builderInitCopy = method.getSimpleName().toString();
                additionalTags = (EncodedElement.Tag[])ObjectArrays.concat((Object[])additionalTags, (Object)((Object)EncodedElement.Tag.COPY));
            }
            return this.processGenericEncodedMethod(method, this.builderInits, additionalTags);
        }

        private boolean processBuilderIsInitMethod(ExecutableElement method) {
            if (this.isInit != null) {
                Encodings.this.reporter.withElement(method).error("@Encoding.IsInit duplicate is init method '%s'. Cannot have more than one", method.getSimpleName());
                return true;
            }
            if (this.typesReader.get(method.getReturnType()) != Type.Primitive.BOOLEAN) {
                Encodings.this.reporter.withElement(method).error("@Encoding.IsInit method '%s' must return boolean if ", method.getSimpleName());
                return true;
            }
            if (!method.getTypeParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.IsInit method '%s' cannot have type parameters", method.getSimpleName());
                return true;
            }
            if (!method.getParameters().isEmpty()) {
                Encodings.this.reporter.withElement(method).error("@Encoding.IsInit method '%s' cannot have parameters", method.getSimpleName());
                return true;
            }
            ArrayList<EncodedElement> captured = new ArrayList<EncodedElement>();
            boolean result = this.processGenericEncodedMethod(method, captured, EncodedElement.Tag.IS_INIT, EncodedElement.Tag.BUILDER, EncodedElement.Tag.PRIVATE);
            if (result) {
                this.isInit = (EncodedElement)captured.get(0);
            }
            return result;
        }

        private boolean processBuilderHelperMethod(ExecutableElement method) {
            return this.processGenericEncodedMethod(method, this.builderHelpers, EncodedElement.Tag.HELPER, EncodedElement.Tag.BUILDER);
        }

        private Set<EncodedElement.Tag> inferTags(Element member, EnumSet<EncodedElement.Tag> tags) {
            if (member.getModifiers().contains((Object)Modifier.STATIC)) {
                tags.add(EncodedElement.Tag.STATIC);
            }
            if (member.getModifiers().contains((Object)Modifier.PRIVATE)) {
                tags.add(EncodedElement.Tag.PRIVATE);
            }
            if (member.getModifiers().contains((Object)Modifier.FINAL)) {
                tags.add(EncodedElement.Tag.FINAL);
            }
            return tags;
        }

        private void provideSyntheticElements() {
            boolean trivialFrom = false;
            if (this.from == null) {
                trivialFrom = true;
                this.from = new EncodedElement.Builder().name(this.synthName("from")).type(this.impl.type()).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.FROM, EncodedElement.Tag.STATIC, EncodedElement.Tag.SYNTH).naming(this.helperNaming("from")).addParams(EncodedElement.Param.of("value", this.impl.type())).typeParameters(this.typesReader.parameters).addAllCode(Code.termsFrom("{\nreturn value;\n}")).build();
            }
            if (this.expose.isEmpty()) {
                this.expose.add(new EncodedElement.Builder().name(this.synthName("get")).type(this.impl.type()).addTags(EncodedElement.Tag.EXPOSE, EncodedElement.Tag.SYNTH).naming(Naming.identity()).typeParameters(this.typesReader.parameters).addAllCode(Code.termsFrom("{\nreturn " + this.impl.name() + ";\n}")).build());
            }
            String exposeName = this.expose.get(0).name();
            if (this.hashCode == null) {
                this.hashCode = new EncodedElement.Builder().name("hashCode").type(Type.Primitive.INT).naming(this.helperNaming("hashCode")).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.HASH_CODE, EncodedElement.Tag.SYNTH).addAllCode(Code.termsFrom("{\nreturn " + exposeName + "().hashCode();\n}")).build();
            }
            if (this.toString == null) {
                this.toString = new EncodedElement.Builder().name("toString").type(Type.Reference.STRING).naming(this.helperNaming("toString")).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.TO_STRING, EncodedElement.Tag.SYNTH).typeParameters(this.typesReader.parameters).addAllCode(Code.termsFrom("{\nreturn " + exposeName + "().toString();\n}")).build();
            }
            if (this.equals == null) {
                this.equals = new EncodedElement.Builder().name("equals").type(Type.Reference.STRING).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.EQUALS, EncodedElement.Tag.SYNTH).naming(this.helperNaming("equals")).typeParameters(this.typesReader.parameters).addParams(EncodedElement.Param.of("other", this.encodingSelfType)).addAllCode(Code.termsFrom("{\nreturn this." + exposeName + "().equals(other." + exposeName + "())\n;}")).build();
            }
            if (this.copy.isEmpty()) {
                this.copy.add(new EncodedElement.Builder().name(this.synthName("copy")).type(this.impl.type()).naming(Naming.identity()).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.COPY, EncodedElement.Tag.SYNTH).addParams(EncodedElement.Param.of("value", this.from.params().get(0).type())).addAllCode(trivialFrom ? Code.termsFrom("{\nreturn value;\n}") : Code.termsFrom("{\nreturn " + this.from.name() + "(value);\n}")).build());
            }
            if (this.typeBuilder == null) {
                String fieldElementName = this.synthName("builder");
                this.builderFields.add(new EncodedElement.Builder().type(Type.Primitive.asNonprimitive(this.impl.type())).name(fieldElementName).naming(this.helperNaming("builder")).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.FIELD, EncodedElement.Tag.BUILDER, EncodedElement.Tag.SYNTH).build());
                this.build = new EncodedElement.Builder().type(this.impl.type()).name(this.synthName("build")).naming(this.helperNaming("build")).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.BUILD, EncodedElement.Tag.BUILDER, EncodedElement.Tag.SYNTH).addAllCode(Code.termsFrom("{\nif (" + fieldElementName + " == null) throw new java.lang.IllegalStateException(\"'<*>' is not initialized\");\nreturn " + fieldElementName + ";\n}")).build();
                this.isInit = new EncodedElement.Builder().name(this.synthName("isSet")).naming(this.helperNaming("isSet")).type(Type.Primitive.BOOLEAN).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.PRIVATE, EncodedElement.Tag.BUILDER, EncodedElement.Tag.IS_INIT, EncodedElement.Tag.SYNTH).addAllCode(Code.termsFrom("{\nreturn this." + fieldElementName + " != null;\n}")).build();
                this.builderInits.add(new EncodedElement.Builder().name(this.synthName("set")).type(Type.Primitive.VOID).naming(Naming.identity()).typeParameters(this.typesReader.parameters).addTags(EncodedElement.Tag.INIT, EncodedElement.Tag.COPY, EncodedElement.Tag.BUILDER, EncodedElement.Tag.SYNTH).addParams(EncodedElement.Param.of("value", this.from.params().get(0).type())).addAllCode(Code.termsFrom("{\nthis." + fieldElementName + " = " + (trivialFrom ? "value" : this.from.name() + "(value)") + ";\n}")).build());
            }
        }

        private String synthName(String name) {
            return Naming.Usage.LOWERIZED.apply(this.name) + "_" + name;
        }

        private List<String> getTypeParameterNames(Parameterizable element) {
            ArrayList<String> names = new ArrayList<String>();
            for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
                names.add(typeParameterElement.getSimpleName().toString());
            }
            return names;
        }

        private List<Code.Term> applyBinder(EncodedElement element, Code.Binder binder) {
            List<Code.Term> result = binder.apply(element.code());
            for (EncodedElement.Param p : element.params()) {
                if (!p.type().equals(this.encodingSelfType)) continue;
                result = binder.parameterAsThis(result, p.name());
            }
            return result;
        }

        class Linkage
        implements Function<EncodedElement, String> {
            private final Set<Code.Binding> staticContext = new LinkedHashSet<Code.Binding>();
            private final Set<Code.Binding> instanceContext = new LinkedHashSet<Code.Binding>();
            private final Set<Code.Binding> builderContext = new LinkedHashSet<Code.Binding>();

            Linkage() {
                this.addStaticMembers(this.staticContext);
                this.addStaticMembers(this.instanceContext);
                this.addStaticMembers(this.builderContext);
                this.addTypeParameters(this.instanceContext);
                this.addTypeParameters(this.builderContext);
                this.addTypeParameters(this.staticContext);
                this.addInstanceMembers(this.instanceContext);
                this.addBuilderMembers(this.builderContext);
            }

            private void addTypeParameters(Set<Code.Binding> context) {
                for (String p : Encoding.this.typeParams) {
                    context.add(Code.Binding.newTop(p));
                }
            }

            private void addBuilderMembers(Set<Code.Binding> context) {
                for (EncodedElement e : Encoding.this.allElements) {
                    if (!e.inBuilder()) continue;
                    context.add(e.asBinding());
                }
            }

            private void addInstanceMembers(Set<Code.Binding> context) {
                for (EncodedElement e : Encoding.this.allElements) {
                    if (e.inBuilder() || e.isStatic()) continue;
                    context.add(e.asBinding());
                }
            }

            private void addStaticMembers(Set<Code.Binding> context) {
                for (EncodedElement e : Encoding.this.allElements) {
                    if (e.inBuilder() || !e.isStatic()) continue;
                    context.add(e.asBinding());
                }
            }

            public String apply(EncodedElement element) {
                Code.Binder linker = this.linkerFor(element);
                List boundTerms = Encoding.this.applyBinder(element, linker);
                return Code.join(Code.trimLeadingIndent(boundTerms));
            }

            private Code.Binder linkerFor(EncodedElement element) {
                LinkedHashSet<Code.Binding> bindings = new LinkedHashSet<Code.Binding>();
                if (element.tags().contains((Object)EncodedElement.Tag.BUILDER)) {
                    bindings.addAll(this.builderContext);
                } else if (element.tags().contains((Object)EncodedElement.Tag.STATIC)) {
                    bindings.addAll(this.staticContext);
                } else {
                    bindings.addAll(this.instanceContext);
                }
                for (EncodedElement.Param p : element.params()) {
                    bindings.add(Code.Binding.newTop(p.name()));
                }
                return new Code.Binder((Map<String, String>)Encoding.this.imports.classes, bindings);
            }
        }
    }
}

