/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.immutables.value.processor.meta.AccessorAttributesCollector;
import org.immutables.value.processor.meta.CachingElements;
import org.immutables.value.processor.meta.FactoryMethodAttributesCollector;
import org.immutables.value.processor.meta.ImmutableMirror;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Reporter;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

public final class ValueTypeComposer {
    private static final CharMatcher ATTRIBUTE_NAME_CHARS = CharMatcher.is((char)'_').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();

    ValueType compose(Proto.Protoclass protoclass) {
        ValueType type = new ValueType();
        type.element = protoclass.sourceElement();
        type.immutableFeatures = protoclass.features();
        type.constitution = protoclass.constitution();
        if (protoclass.kind().isFactory()) {
            new FactoryMethodAttributesCollector(protoclass, type).collect();
        } else if (protoclass.kind().isValue() || protoclass.kind().isModifiable()) {
            ArrayList violations = Lists.newArrayList();
            if (ValueTypeComposer.checkAbstractValueType(type.element, violations)) {
                if (protoclass.kind().isValue()) {
                    this.checkForMutableFields(protoclass, (TypeElement)type.element);
                    this.checkForTypeHierarchy(protoclass, type);
                }
                new AccessorAttributesCollector(protoclass, type).collect();
            } else {
                protoclass.report().error("Value type '%s' %s", protoclass.sourceElement().getSimpleName(), Joiner.on((String)", ").join((Iterable)violations));
            }
            type.detectSerialization();
        }
        this.checkAttributeNamesIllegalCharacters(type);
        this.checkAttributeNamesForDuplicates(type, protoclass);
        this.checkConstructability(type);
        this.checkStyleConflicts(type, protoclass);
        return type;
    }

    private void checkAttributeNamesIllegalCharacters(ValueType type) {
        for (ValueAttribute a : type.attributes) {
            if (ATTRIBUTE_NAME_CHARS.matchesAllOf((CharSequence)a.name())) continue;
            a.report().error("Name '%s' contains some unsupported or reserved characters, please use only A-Z, a-z, 0-9 and _ chars", a.name());
        }
    }

    private void checkConstructability(ValueType type) {
        if (!type.isUseBuilder() || type.isUseConstructor()) {
            for (ValueAttribute a : type.getConstructorExcluded()) {
                if (!a.isMandatory()) continue;
                a.report().error("Attribute '%s' is mandatory and should be a constructor @Value.Parameter when builder is disabled or there are other constructor parameters", a.name());
            }
        }
        if (!type.isUseBuilder() && !type.isUseCopyMethods()) {
            for (ValueAttribute a : type.getConstructorExcluded()) {
                if (a.isMandatory()) continue;
                a.report().warning("There is no way to initialize '%s' attribute to non-default value. Enable builder=true or copy=true or add it as a constructor @Value.Parameter", a.name());
            }
        }
        if (type.isUseSingleton() && !type.getMandatoryAttributes().isEmpty()) {
            for (ValueAttribute a : type.getMandatoryAttributes()) {
                if (!a.isMandatory()) continue;
                a.report().error("Attribute '%s' is mandatory and cannot be used with singleton enabled. Singleton instance require all attributes to have default value, otherwise default instance could not be created", a.name());
            }
        }
    }

    private void checkStyleConflicts(ValueType type, Proto.Protoclass protoclass) {
        if (protoclass.features().prehash() && protoclass.styles().style().privateNoargConstructor()) {
            protoclass.report().annotationNamed(ImmutableMirror.simpleName()).warning("'prehash' feature is automatically disabled when 'privateNoargConstructor' style is turned on", new Object[0]);
        }
        if (type.isUseConstructor() && protoclass.constitution().factoryOf().isNew()) {
            if (type.isUseValidation()) {
                protoclass.report().annotationNamed(ImmutableMirror.simpleName()).error("interning, singleton and validation will not work correctly with 'new' constructor configured in style", new Object[0]);
            } else if (type.constitution.isImplementationHidden() && (type.kind().isEnclosing() || type.kind().isNested())) {
                protoclass.report().annotationNamed(ImmutableMirror.simpleName()).error("Enclosing with hidden implementation do not mix with 'new' constructor configured in style", new Object[0]);
            }
        }
    }

    private void checkForTypeHierarchy(Proto.Protoclass protoclass, ValueType type) {
        ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.extendedClasses());
        ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.implementedInterfaces());
    }

    private static void scanAndReportInvalidInheritance(Proto.Protoclass protoclass, Element element, Iterable<DeclaredType> supertypes) {
        for (TypeElement supertype : Iterables.transform(supertypes, (Function)Proto.DeclatedTypeToElement.FUNCTION)) {
            if (CachingElements.equals(element, supertype) || !ImmutableMirror.isPresent(supertype)) continue;
            protoclass.report().error("Should not inherit %s which is a value type itself. Avoid extending from another abstract value type. Better to share common abstract class or interface which are not carrying @%s annotation", supertype, ImmutableMirror.simpleName());
        }
    }

    private void checkForMutableFields(Proto.Protoclass protoclass, TypeElement element) {
        Elements elementUtils = protoclass.environment().processing().getElementUtils();
        for (VariableElement field : ElementFilter.fieldsIn(elementUtils.getAllMembers(CachingElements.getDelegate(element)))) {
            if (field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            Reporter report = protoclass.report();
            boolean ownField = CachingElements.equals(element, field.getEnclosingElement());
            if (ownField) {
                report.withElement(field).warning("Avoid introduction of fields (except constants) in abstract value types", new Object[0]);
                continue;
            }
            report.warning("Abstract value type inherits mutable fields", new Object[0]);
        }
    }

    private void checkAttributeNamesForDuplicates(ValueType type, Proto.Protoclass protoclass) {
        if (!type.attributes.isEmpty()) {
            HashMultiset attributeNames = HashMultiset.create((int)type.attributes.size());
            for (ValueAttribute attribute : type.attributes) {
                attributeNames.add((Object)attribute.name());
            }
            ArrayList duplicates = Lists.newArrayList();
            for (Multiset.Entry entry : attributeNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                duplicates.add(entry.getElement());
            }
            if (!duplicates.isEmpty()) {
                protoclass.report().error("Duplicate attribute names %s. You should check if correct @Value.Style applied", duplicates);
            }
        }
    }

    static boolean checkAbstractValueType(Element element, Collection<String> violations) {
        boolean publicOrPackageVisible;
        boolean ofSupportedKind = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE || element.getKind() == ElementKind.CLASS;
        boolean staticOrTopLevel = element.getEnclosingElement().getKind() == ElementKind.PACKAGE || element.getModifiers().contains((Object)Modifier.STATIC);
        boolean nonFinal = !element.getModifiers().contains((Object)Modifier.FINAL);
        boolean hasNoTypeParameters = ((TypeElement)element).getTypeParameters().isEmpty();
        boolean bl = publicOrPackageVisible = !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.PROTECTED);
        if (!ofSupportedKind) {
            violations.add("must be class or interface or annotation type");
        }
        if (!nonFinal) {
            violations.add("must be non-final");
        }
        if (!hasNoTypeParameters) {
            violations.add("should have no type parameters");
        }
        if (!publicOrPackageVisible) {
            violations.add("should be public or package-visible");
        }
        if (!staticOrTopLevel) {
            violations.add("should be top-level or static inner class");
        }
        return violations.isEmpty();
    }
}

