/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import javax.lang.model.type.TypeMirror;
import org.immutables.generator.TypeHierarchyCollector;

public abstract class TypeIntrospectionBase {
    static final String ORDINAL_VALUE_INTERFACE_TYPE = "org.immutables.ordinal.OrdinalValue";
    protected static final ImmutableBiMap<String, String> BOXED_TO_PRIMITIVE_TYPES;
    private volatile boolean introspected;
    protected ImmutableList<String> extendedClassesNames;
    protected ImmutableSet<String> implementedInterfacesNames;

    protected static boolean isPrimitiveType(String typeName) {
        return BOXED_TO_PRIMITIVE_TYPES.containsValue((Object)typeName);
    }

    protected static boolean isPrimitiveWrappedType(String name) {
        return BOXED_TO_PRIMITIVE_TYPES.containsKey((Object)name);
    }

    protected static boolean isPrimitiveOrWrapped(String name) {
        return TypeIntrospectionBase.isPrimitiveType(name) || TypeIntrospectionBase.isPrimitiveWrappedType(name);
    }

    protected static String wrapType(String typeName) {
        return (String)MoreObjects.firstNonNull((Object)BOXED_TO_PRIMITIVE_TYPES.inverse().get((Object)typeName), (Object)typeName);
    }

    protected static String unwrapType(String typeName) {
        return (String)MoreObjects.firstNonNull((Object)BOXED_TO_PRIMITIVE_TYPES.get((Object)typeName), (Object)typeName);
    }

    protected abstract TypeMirror internalTypeMirror();

    protected void ensureTypeIntrospected() {
        if (!this.introspected) {
            this.introspectType();
            this.introspected = true;
        }
    }

    public ImmutableList<String> getExtendedClassesNames() {
        this.ensureTypeIntrospected();
        return this.extendedClassesNames;
    }

    public ImmutableSet<String> getImplementedInterfacesNames() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames;
    }

    public boolean isComparable() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains((Object)Comparable.class.getName());
    }

    public boolean isOrdinalValue() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains((Object)ORDINAL_VALUE_INTERFACE_TYPE);
    }

    public boolean isEnumType() {
        this.ensureTypeIntrospected();
        return this.extendedClassesNames.contains((Object)Enum.class.getName());
    }

    public boolean isSerializable() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains((Object)Serializable.class.getName());
    }

    public String getDirectSupertype() {
        this.ensureTypeIntrospected();
        return (String)Iterables.getFirst(this.extendedClassesNames, null);
    }

    protected void introspectType() {
        this.intospectTypeMirror(this.internalTypeMirror());
    }

    protected void intospectTypeMirror(TypeMirror typeMirror) {
        TypeHierarchyCollector collector = this.collectTypeHierarchy(typeMirror);
        this.extendedClassesNames = collector.extendedClassNames();
        this.implementedInterfacesNames = collector.implementedInterfaceNames();
    }

    protected TypeHierarchyCollector collectTypeHierarchy(TypeMirror typeMirror) {
        TypeHierarchyCollector collector = new TypeHierarchyCollector();
        collector.collectFrom(typeMirror);
        return collector;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Class primitive : Primitives.allPrimitiveTypes()) {
            builder.put((Object)Primitives.wrap((Class)primitive).getName(), (Object)primitive.getName());
        }
        BOXED_TO_PRIMITIVE_TYPES = builder.build();
    }
}

