/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.MongoMirrors;

public class RepositoryMirror
implements MongoMirrors.Repository {
    public static final String QUALIFIED_NAME = "org.immutables.mongo.Mongo.Repository";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.MongoMirrors.Repository";
    private final AnnotationMirror annotationMirror;
    private final String value;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Repository";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<RepositoryMirror> find(Element element) {
        return RepositoryMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<RepositoryMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new RepositoryMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<RepositoryMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new RepositoryMirror(annotationMirror));
        }
        return builder.build();
    }

    public static RepositoryMirror from(TypeElement element) {
        return new RepositoryMirror(element);
    }

    public static Optional<RepositoryMirror> from(AnnotationMirror mirror) {
        return RepositoryMirror.find(Collections.singleton(mirror));
    }

    private RepositoryMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        String value = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Repository");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.value = (String)Preconditions.checkNotNull(value, (Object)"default attribute 'value'");
    }

    private RepositoryMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String value = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Repository");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
        }
        this.value = (String)Preconditions.checkNotNull(value, (Object)"value for 'value'");
    }

    @Override
    public String value() {
        return this.value;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return MongoMirrors.Repository.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "value".hashCode() ^ this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RepositoryMirror) {
            RepositoryMirror otherMirror = (RepositoryMirror)other;
            return this.value.equals(otherMirror.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return "RepositoryMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ValueExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.mongo.Mongo.Repository");
        }
    }
}

