/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

class ImportRewriteDisabler {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final String WARNING_START = "Import rewriter will be disabled for generated source files to not mess up with";

    ImportRewriteDisabler() {
    }

    static boolean shouldDisableFor(ValueType type) {
        for (String segment : DOT_SPLITTER.split((CharSequence)type.constitution.implementationPackage())) {
            if (segment.isEmpty() || !Ascii.isUpperCase((char)segment.charAt(0))) continue;
            type.constitution.protoclass().report().warning("Import rewriter will be disabled for generated source files to not mess up with uppercase package names", new Object[0]);
            return true;
        }
        for (Element element = type.constitution.protoclass().sourceElement(); element != null; element = element.getEnclosingElement()) {
            if (element.getKind() == ElementKind.PACKAGE) {
                for (String segment : DOT_SPLITTER.split((CharSequence)((PackageElement)element).getQualifiedName())) {
                    if (segment.isEmpty() || !Ascii.isUpperCase((char)segment.charAt(0))) continue;
                    type.constitution.protoclass().report().warning("Import rewriter will be disabled for generated source files to not mess up with uppercase package names", new Object[0]);
                    return true;
                }
            }
            if (!element.getKind().isClass() && !element.getKind().isInterface() || !Ascii.isLowerCase((char)element.getSimpleName().charAt(0))) continue;
            type.constitution.protoclass().report().warning("Import rewriter will be disabled for generated source files to not mess up with lowercase class names", new Object[0]);
            return true;
        }
        for (ValueAttribute attribute : type.attributes) {
            if (!Ascii.isUpperCase((char)attribute.names.get.charAt(0))) continue;
            type.constitution.protoclass().report().warning("Import rewriter will be disabled for generated source files to not mess up with uppercase attribute names", new Object[0]);
            return true;
        }
        for (ValueType nested : type.nested) {
            if (!ImportRewriteDisabler.shouldDisableFor(nested)) continue;
            return true;
        }
        return false;
    }
}

