/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.immutables.value.processor.meta.Reporter;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableReporter
extends Reporter {
    private final Messager messager;
    private final Optional<Element> element;
    private final Optional<AnnotationMirror> annotation;

    private ImmutableReporter(Messager messager) {
        this.messager = (Messager)Preconditions.checkNotNull((Object)messager);
        this.element = Optional.absent();
        this.annotation = Optional.absent();
    }

    private ImmutableReporter(ImmutableReporter original, Messager messager, Optional<Element> element, Optional<AnnotationMirror> annotation) {
        this.messager = messager;
        this.element = element;
        this.annotation = annotation;
    }

    public final ImmutableReporter withMessager(Messager value) {
        if (this.messager == value) {
            return this;
        }
        Messager newValue = (Messager)Preconditions.checkNotNull((Object)value);
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(this, newValue, this.element, this.annotation));
    }

    @Override
    public final ImmutableReporter withElement(Element value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(this, this.messager, (Optional<Element>)newValue, this.annotation));
    }

    public final ImmutableReporter withElement(Optional<Element> optional) {
        if (this.element == optional) {
            return this;
        }
        Optional newValue = (Optional)Preconditions.checkNotNull(optional);
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(this, this.messager, (Optional<Element>)newValue, this.annotation));
    }

    @Override
    public final ImmutableReporter withAnnotation(AnnotationMirror value) {
        Optional newValue = Optional.of((Object)value);
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(this, this.messager, this.element, (Optional<AnnotationMirror>)newValue));
    }

    public final ImmutableReporter withAnnotation(Optional<AnnotationMirror> optional) {
        if (this.annotation == optional) {
            return this;
        }
        Optional newValue = (Optional)Preconditions.checkNotNull(optional);
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(this, this.messager, this.element, (Optional<AnnotationMirror>)newValue));
    }

    @Override
    public Messager messager() {
        return this.messager;
    }

    @Override
    public Optional<Element> element() {
        return this.element;
    }

    @Override
    public Optional<AnnotationMirror> annotation() {
        return this.annotation;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableReporter && this.equalTo((ImmutableReporter)another);
    }

    private boolean equalTo(ImmutableReporter another) {
        return this.messager.equals(another.messager) && this.element.equals(another.element) && this.annotation.equals(another.annotation);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.messager.hashCode();
        h = h * 17 + this.element.hashCode();
        h = h * 17 + this.annotation.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Reporter").omitNullValues().add("messager", (Object)this.messager).add("element", this.element.orNull()).add("annotation", this.annotation.orNull()).toString();
    }

    public static ImmutableReporter of(Messager messager) {
        return ImmutableReporter.checkPreconditions(new ImmutableReporter(messager));
    }

    private static ImmutableReporter checkPreconditions(ImmutableReporter instance) {
        return instance;
    }

    static ImmutableReporter copyOf(Reporter instance) {
        if (instance instanceof ImmutableReporter) {
            return (ImmutableReporter)instance;
        }
        return ImmutableReporter.of(instance.messager()).withElement(instance.element()).withAnnotation(instance.annotation());
    }

    @Deprecated
    static ImmutableReporter copyOf(ImmutableReporter instance) {
        return (ImmutableReporter)Preconditions.checkNotNull((Object)instance);
    }
}

