/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.lang.model.element.TypeElement;
import org.immutables.value.processor.meta.ValueAttribute;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableNullabilityAnnotationInfo
extends ValueAttribute.NullabilityAnnotationInfo {
    private final TypeElement element;
    private final String qualifiedName;
    private final int hashCode;
    @GuardedBy(value="this")
    private volatile long lazyInitBitmap;
    private static final long AS_PREFIX_LAZY_INIT_BIT = 1L;
    @GuardedBy(value="this")
    private String asPrefix;
    private static final long AS_LOCAL_PREFIX_LAZY_INIT_BIT = 2L;
    @GuardedBy(value="this")
    private String asLocalPrefix;
    private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

    private ImmutableNullabilityAnnotationInfo(TypeElement element) {
        this.element = (TypeElement)Preconditions.checkNotNull((Object)element);
        this.qualifiedName = (String)Preconditions.checkNotNull((Object)super.qualifiedName());
        this.hashCode = this.computeHashCode();
    }

    private ImmutableNullabilityAnnotationInfo(ImmutableNullabilityAnnotationInfo original, TypeElement element, String qualifiedName) {
        this.element = element;
        this.qualifiedName = qualifiedName;
        this.hashCode = this.computeHashCode();
    }

    public final ImmutableNullabilityAnnotationInfo withElement(TypeElement value) {
        if (this.element == value) {
            return this;
        }
        TypeElement newValue = (TypeElement)Preconditions.checkNotNull((Object)value);
        return ImmutableNullabilityAnnotationInfo.checkPreconditions(new ImmutableNullabilityAnnotationInfo(this, newValue, this.qualifiedName));
    }

    @Override
    public TypeElement element() {
        return this.element;
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    public boolean equals(@Nullable Object another) {
        return this == another;
    }

    private boolean equalTo(ImmutableNullabilityAnnotationInfo another) {
        return this.qualifiedName.equals(another.qualifiedName);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.qualifiedName.hashCode();
        return h;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullabilityAnnotationInfo").omitNullValues().add("qualifiedName", (Object)this.qualifiedName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asPrefix() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableNullabilityAnnotationInfo immutableNullabilityAnnotationInfo = this;
            synchronized (immutableNullabilityAnnotationInfo) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.asPrefix = (String)Preconditions.checkNotNull((Object)super.asPrefix());
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.asPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asLocalPrefix() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableNullabilityAnnotationInfo immutableNullabilityAnnotationInfo = this;
            synchronized (immutableNullabilityAnnotationInfo) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.asLocalPrefix = (String)Preconditions.checkNotNull((Object)super.asLocalPrefix());
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.asLocalPrefix;
    }

    private static ImmutableNullabilityAnnotationInfo intern(ImmutableNullabilityAnnotationInfo instance) {
        return ((InternProxy)ImmutableNullabilityAnnotationInfo.INTERNER.intern((Object)new InternProxy((ImmutableNullabilityAnnotationInfo)instance))).instance;
    }

    public static ImmutableNullabilityAnnotationInfo of(TypeElement element) {
        return ImmutableNullabilityAnnotationInfo.checkPreconditions(new ImmutableNullabilityAnnotationInfo(element));
    }

    private static ImmutableNullabilityAnnotationInfo checkPreconditions(ImmutableNullabilityAnnotationInfo instance) {
        instance = ImmutableNullabilityAnnotationInfo.intern(instance);
        return instance;
    }

    static ImmutableNullabilityAnnotationInfo copyOf(ValueAttribute.NullabilityAnnotationInfo instance) {
        if (instance instanceof ImmutableNullabilityAnnotationInfo) {
            return (ImmutableNullabilityAnnotationInfo)instance;
        }
        return ImmutableNullabilityAnnotationInfo.of(instance.element());
    }

    @Deprecated
    static ImmutableNullabilityAnnotationInfo copyOf(ImmutableNullabilityAnnotationInfo instance) {
        return (ImmutableNullabilityAnnotationInfo)Preconditions.checkNotNull((Object)instance);
    }

    private static class InternProxy {
        final ImmutableNullabilityAnnotationInfo instance;

        InternProxy(ImmutableNullabilityAnnotationInfo instance) {
            this.instance = instance;
        }

        public boolean equals(@Nullable Object another) {
            assert (another instanceof InternProxy);
            return this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.computeHashCode();
        }
    }
}

