/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.processor.meta.Constitution;
import org.immutables.value.processor.meta.Generics;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Styles;
import org.immutables.value.processor.meta.Visibility;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableConstitution
extends Constitution {
    private final Proto.Protoclass protoclass;
    private final Visibility implementationVisibility;
    private final Visibility builderVisibility;
    private final String implementationPackage;
    private final Styles.UsingName.TypeNames names;
    private final boolean hasImmutableInBuilder;
    @GuardedBy(value="this")
    private volatile long lazyInitBitmap;
    private static final long GENERICS_LAZY_INIT_BIT = 1L;
    @GuardedBy(value="this")
    private Generics generics;
    private static final long TYPE_PREFERABLY_ABSTRACT_LAZY_INIT_BIT = 2L;
    @GuardedBy(value="this")
    private Constitution.NameForms typePreferablyAbstract;
    private static final long TYPE_DOCUMENT_LAZY_INIT_BIT = 4L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeDocument;
    private static final long TYPE_VALUE_LAZY_INIT_BIT = 8L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeValue;
    private static final long TYPE_ABSTRACT_LAZY_INIT_BIT = 16L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeAbstract;
    private static final long TYPE_IMMUTABLE_LAZY_INIT_BIT = 32L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeImmutable;
    private static final long TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT = 64L;
    @GuardedBy(value="this")
    private String typeImmutableEnclosingSimpleName;
    private static final long FACTORY_BUILDER_LAZY_INIT_BIT = 128L;
    @GuardedBy(value="this")
    private Constitution.AppliedNameForms factoryBuilder;
    private static final long FACTORY_OF_LAZY_INIT_BIT = 256L;
    @GuardedBy(value="this")
    private Constitution.AppliedNameForms factoryOf;
    private static final long FACTORY_INSTANCE_LAZY_INIT_BIT = 512L;
    @GuardedBy(value="this")
    private Constitution.AppliedNameForms factoryInstance;
    private static final long FACTORY_COPY_OF_LAZY_INIT_BIT = 1024L;
    @GuardedBy(value="this")
    private Constitution.AppliedNameForms factoryCopyOf;
    private static final long TYPE_ENCLOSING_FACTORY_LAZY_INIT_BIT = 2048L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeEnclosingFactory;
    private static final long TYPE_ENCLOSING_LAZY_INIT_BIT = 4096L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeEnclosing;
    private static final long TYPE_WITH_LAZY_INIT_BIT = 8192L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeWith;
    private static final long TYPE_BUILDER_LAZY_INIT_BIT = 16384L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeBuilder;
    private static final long TYPE_IMPLEMENTATION_BUILDER_LAZY_INIT_BIT = 32768L;
    @GuardedBy(value="this")
    private Constitution.NameForms typeImplementationBuilder;
    private static final long INNER_BUILDER_LAZY_INIT_BIT = 65536L;
    @GuardedBy(value="this")
    private Constitution.InnerBuilderDefinition innerBuilder;

    private ImmutableConstitution(Builder builder) {
        this.protoclass = builder.protoclass;
        this.implementationVisibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)super.implementationVisibility())));
        this.builderVisibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)super.builderVisibility())));
        this.implementationPackage = (String)Preconditions.checkNotNull((Object)super.implementationPackage());
        this.names = (Styles.UsingName.TypeNames)Preconditions.checkNotNull((Object)super.names());
        this.hasImmutableInBuilder = super.hasImmutableInBuilder();
    }

    private ImmutableConstitution(ImmutableConstitution original, Proto.Protoclass protoclass, Visibility implementationVisibility, Visibility builderVisibility, String implementationPackage, Styles.UsingName.TypeNames names, boolean hasImmutableInBuilder) {
        this.protoclass = protoclass;
        this.implementationVisibility = implementationVisibility;
        this.builderVisibility = builderVisibility;
        this.implementationPackage = implementationPackage;
        this.names = names;
        this.hasImmutableInBuilder = hasImmutableInBuilder;
    }

    public final ImmutableConstitution withProtoclass(Proto.Protoclass value) {
        if (this.protoclass == value) {
            return this;
        }
        Proto.Protoclass newValue = (Proto.Protoclass)Preconditions.checkNotNull((Object)value);
        return ImmutableConstitution.checkPreconditions(new ImmutableConstitution(this, newValue, this.implementationVisibility, this.builderVisibility, this.implementationPackage, this.names, this.hasImmutableInBuilder));
    }

    @Override
    public Proto.Protoclass protoclass() {
        return this.protoclass;
    }

    @Override
    public Visibility implementationVisibility() {
        return this.implementationVisibility;
    }

    @Override
    public Visibility builderVisibility() {
        return this.builderVisibility;
    }

    @Override
    public String implementationPackage() {
        return this.implementationPackage;
    }

    @Override
    public Styles.UsingName.TypeNames names() {
        return this.names;
    }

    @Override
    public boolean hasImmutableInBuilder() {
        return this.hasImmutableInBuilder;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableConstitution && this.equalTo((ImmutableConstitution)another);
    }

    private boolean equalTo(ImmutableConstitution another) {
        return this.protoclass.equals(another.protoclass) && this.implementationVisibility.equals((Object)another.implementationVisibility) && this.builderVisibility.equals((Object)another.builderVisibility) && this.implementationPackage.equals(another.implementationPackage) && this.names.equals(another.names) && this.hasImmutableInBuilder == another.hasImmutableInBuilder;
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.protoclass.hashCode();
        h = h * 17 + this.implementationVisibility.hashCode();
        h = h * 17 + this.builderVisibility.hashCode();
        h = h * 17 + this.implementationPackage.hashCode();
        h = h * 17 + this.names.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.hasImmutableInBuilder);
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Constitution").omitNullValues().add("protoclass", (Object)this.protoclass).add("implementationVisibility", (Object)this.implementationVisibility).add("builderVisibility", (Object)this.builderVisibility).add("implementationPackage", (Object)this.implementationPackage).add("names", (Object)this.names).add("hasImmutableInBuilder", this.hasImmutableInBuilder).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Generics generics() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.generics = (Generics)Preconditions.checkNotNull((Object)super.generics());
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.generics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typePreferablyAbstract() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.typePreferablyAbstract = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typePreferablyAbstract());
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.typePreferablyAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeDocument() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.typeDocument = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeDocument());
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.typeDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeValue() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.typeValue = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeValue());
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.typeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeAbstract() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.typeAbstract = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeAbstract());
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.typeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeImmutable() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.typeImmutable = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeImmutable());
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.typeImmutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String typeImmutableEnclosingSimpleName() {
        if ((this.lazyInitBitmap & 0x40L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x40L) == 0L) {
                    this.typeImmutableEnclosingSimpleName = (String)Preconditions.checkNotNull((Object)super.typeImmutableEnclosingSimpleName());
                    this.lazyInitBitmap |= 0x40L;
                }
            }
        }
        return this.typeImmutableEnclosingSimpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.AppliedNameForms factoryBuilder() {
        if ((this.lazyInitBitmap & 0x80L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x80L) == 0L) {
                    this.factoryBuilder = (Constitution.AppliedNameForms)Preconditions.checkNotNull((Object)super.factoryBuilder());
                    this.lazyInitBitmap |= 0x80L;
                }
            }
        }
        return this.factoryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.AppliedNameForms factoryOf() {
        if ((this.lazyInitBitmap & 0x100L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x100L) == 0L) {
                    this.factoryOf = (Constitution.AppliedNameForms)Preconditions.checkNotNull((Object)super.factoryOf());
                    this.lazyInitBitmap |= 0x100L;
                }
            }
        }
        return this.factoryOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.AppliedNameForms factoryInstance() {
        if ((this.lazyInitBitmap & 0x200L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x200L) == 0L) {
                    this.factoryInstance = (Constitution.AppliedNameForms)Preconditions.checkNotNull((Object)super.factoryInstance());
                    this.lazyInitBitmap |= 0x200L;
                }
            }
        }
        return this.factoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.AppliedNameForms factoryCopyOf() {
        if ((this.lazyInitBitmap & 0x400L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x400L) == 0L) {
                    this.factoryCopyOf = (Constitution.AppliedNameForms)Preconditions.checkNotNull((Object)super.factoryCopyOf());
                    this.lazyInitBitmap |= 0x400L;
                }
            }
        }
        return this.factoryCopyOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeEnclosingFactory() {
        if ((this.lazyInitBitmap & 0x800L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x800L) == 0L) {
                    this.typeEnclosingFactory = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeEnclosingFactory());
                    this.lazyInitBitmap |= 0x800L;
                }
            }
        }
        return this.typeEnclosingFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeEnclosing() {
        if ((this.lazyInitBitmap & 0x1000L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                    this.typeEnclosing = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeEnclosing());
                    this.lazyInitBitmap |= 0x1000L;
                }
            }
        }
        return this.typeEnclosing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeWith() {
        if ((this.lazyInitBitmap & 0x2000L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x2000L) == 0L) {
                    this.typeWith = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeWith());
                    this.lazyInitBitmap |= 0x2000L;
                }
            }
        }
        return this.typeWith;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeBuilder() {
        if ((this.lazyInitBitmap & 0x4000L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x4000L) == 0L) {
                    this.typeBuilder = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeBuilder());
                    this.lazyInitBitmap |= 0x4000L;
                }
            }
        }
        return this.typeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.NameForms typeImplementationBuilder() {
        if ((this.lazyInitBitmap & 0x8000L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x8000L) == 0L) {
                    this.typeImplementationBuilder = (Constitution.NameForms)Preconditions.checkNotNull((Object)super.typeImplementationBuilder());
                    this.lazyInitBitmap |= 0x8000L;
                }
            }
        }
        return this.typeImplementationBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constitution.InnerBuilderDefinition innerBuilder() {
        if ((this.lazyInitBitmap & 0x10000L) == 0L) {
            ImmutableConstitution immutableConstitution = this;
            synchronized (immutableConstitution) {
                if ((this.lazyInitBitmap & 0x10000L) == 0L) {
                    this.innerBuilder = (Constitution.InnerBuilderDefinition)Preconditions.checkNotNull((Object)super.innerBuilder());
                    this.lazyInitBitmap |= 0x10000L;
                }
            }
        }
        return this.innerBuilder;
    }

    private static ImmutableConstitution checkPreconditions(ImmutableConstitution instance) {
        return instance;
    }

    public static ImmutableConstitution copyOf(Constitution instance) {
        if (instance instanceof ImmutableConstitution) {
            return (ImmutableConstitution)instance;
        }
        Preconditions.checkNotNull((Object)instance);
        return ImmutableConstitution.builder().protoclass(instance.protoclass()).build();
    }

    @Deprecated
    public static ImmutableConstitution copyOf(ImmutableConstitution instance) {
        return (ImmutableConstitution)Preconditions.checkNotNull((Object)instance);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Immutable
    public static final class NameForms
    extends Constitution.NameForms {
        private final String simple;
        private final String relative;
        private final String packageOf;
        private final Visibility visibility;
        private final boolean relativeAlreadyQualified;

        private NameForms(Builder builder) {
            this.simple = builder.simple;
            this.relative = builder.relative;
            this.packageOf = builder.packageOf;
            this.visibility = builder.visibility;
            this.relativeAlreadyQualified = builder.relativeAlreadyQualifiedIsSet() ? builder.relativeAlreadyQualified : super.relativeAlreadyQualified();
        }

        private NameForms(NameForms original, String simple, String relative, String packageOf, Visibility visibility, boolean relativeAlreadyQualified) {
            this.simple = simple;
            this.relative = relative;
            this.packageOf = packageOf;
            this.visibility = visibility;
            this.relativeAlreadyQualified = relativeAlreadyQualified;
        }

        public final NameForms withSimple(String value) {
            if (this.simple == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return NameForms.checkPreconditions(new NameForms(this, newValue, this.relative, this.packageOf, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withRelative(String value) {
            if (this.relative == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return NameForms.checkPreconditions(new NameForms(this, this.simple, newValue, this.packageOf, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withPackageOf(String value) {
            if (this.packageOf == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, newValue, this.visibility, this.relativeAlreadyQualified));
        }

        public final NameForms withVisibility(Visibility value) {
            if (this.visibility == value) {
                return this;
            }
            Visibility newValue = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)value)));
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, this.packageOf, newValue, this.relativeAlreadyQualified));
        }

        public final NameForms withRelativeAlreadyQualified(boolean value) {
            if (this.relativeAlreadyQualified == value) {
                return this;
            }
            boolean newValue = value;
            return NameForms.checkPreconditions(new NameForms(this, this.simple, this.relative, this.packageOf, this.visibility, newValue));
        }

        @Override
        public String simple() {
            return this.simple;
        }

        @Override
        public String relative() {
            return this.relative;
        }

        @Override
        public String packageOf() {
            return this.packageOf;
        }

        @Override
        public Visibility visibility() {
            return this.visibility;
        }

        @Override
        public boolean relativeAlreadyQualified() {
            return this.relativeAlreadyQualified;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof NameForms && this.equalTo((NameForms)another);
        }

        private boolean equalTo(NameForms another) {
            return this.simple.equals(another.simple) && this.relative.equals(another.relative) && this.packageOf.equals(another.packageOf) && this.visibility.equals((Object)another.visibility) && this.relativeAlreadyQualified == another.relativeAlreadyQualified;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.simple.hashCode();
            h = h * 17 + this.relative.hashCode();
            h = h * 17 + this.packageOf.hashCode();
            h = h * 17 + this.visibility.hashCode();
            h = h * 17 + Booleans.hashCode((boolean)this.relativeAlreadyQualified);
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        private static NameForms checkPreconditions(NameForms instance) {
            return instance;
        }

        public static NameForms copyOf(Constitution.NameForms instance) {
            if (instance instanceof NameForms) {
                return (NameForms)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return NameForms.builder().simple(instance.simple()).relative(instance.relative()).packageOf(instance.packageOf()).visibility(instance.visibility()).relativeAlreadyQualified(instance.relativeAlreadyQualified()).build();
        }

        @Deprecated
        public static NameForms copyOf(NameForms instance) {
            return (NameForms)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 15L;
            private static final long NONDEFAULT_BIT_RELATIVE_ALREADY_QUALIFIED = 1L;
            private static final long INITIALIZED_BIT_SIMPLE = 1L;
            private static final long INITIALIZED_BIT_RELATIVE = 2L;
            private static final long INITIALIZED_BIT_PACKAGE_OF = 4L;
            private static final long INITIALIZED_BIT_VISIBILITY = 8L;
            private long nondefaultBitset;
            private long initializedBitset;
            @Nullable
            private String simple;
            @Nullable
            private String relative;
            @Nullable
            private String packageOf;
            @Nullable
            private Visibility visibility;
            private boolean relativeAlreadyQualified;

            private Builder() {
            }

            public final Builder simple(String simple) {
                this.simple = (String)Preconditions.checkNotNull((Object)simple);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder relative(String relative) {
                this.relative = (String)Preconditions.checkNotNull((Object)relative);
                this.initializedBitset |= 2L;
                return this;
            }

            public final Builder packageOf(String packageOf) {
                this.packageOf = (String)Preconditions.checkNotNull((Object)packageOf);
                this.initializedBitset |= 4L;
                return this;
            }

            public final Builder visibility(Visibility visibility) {
                this.visibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)visibility)));
                this.initializedBitset |= 8L;
                return this;
            }

            public final Builder relativeAlreadyQualified(boolean relativeAlreadyQualified) {
                this.relativeAlreadyQualified = relativeAlreadyQualified;
                this.nondefaultBitset |= 1L;
                return this;
            }

            public NameForms build() {
                this.checkRequiredAttributes();
                return NameForms.checkPreconditions(new NameForms(this));
            }

            private boolean relativeAlreadyQualifiedIsSet() {
                return (this.nondefaultBitset & 1L) != 0L;
            }

            private boolean simpleIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean relativeIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private boolean packageOfIsSet() {
                return (this.initializedBitset & 4L) != 0L;
            }

            private boolean visibilityIsSet() {
                return (this.initializedBitset & 8L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 15L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build NameForms, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.simpleIsSet() ? "simple" : null)).addValue((Object)(!this.relativeIsSet() ? "relative" : null)).addValue((Object)(!this.packageOfIsSet() ? "packageOf" : null)).addValue((Object)(!this.visibilityIsSet() ? "visibility" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableConstitution.NameForms.Builder").omitNullValues().add("simple", (Object)this.simple).add("relative", (Object)this.relative).add("packageOf", (Object)this.packageOf).add("visibility", (Object)this.visibility).add("relativeAlreadyQualified", this.relativeAlreadyQualifiedIsSet() ? Boolean.valueOf(this.relativeAlreadyQualified) : null).toString();
            }
        }
    }

    @Immutable
    public static final class AppliedNameForms
    extends Constitution.AppliedNameForms {
        private final Constitution.NameForms forms;
        private final String applied;
        private final String simple;
        private final boolean isNew;

        private AppliedNameForms(Builder builder) {
            this.forms = builder.forms;
            this.applied = builder.applied;
            this.simple = (String)Preconditions.checkNotNull((Object)super.simple());
            this.isNew = super.isNew();
        }

        private AppliedNameForms(AppliedNameForms original, Constitution.NameForms forms, String applied, String simple, boolean isNew) {
            this.forms = forms;
            this.applied = applied;
            this.simple = simple;
            this.isNew = isNew;
        }

        public final AppliedNameForms withForms(Constitution.NameForms value) {
            if (this.forms == value) {
                return this;
            }
            Constitution.NameForms newValue = (Constitution.NameForms)Preconditions.checkNotNull((Object)value);
            return AppliedNameForms.checkPreconditions(new AppliedNameForms(this, newValue, this.applied, this.simple, this.isNew));
        }

        public final AppliedNameForms withApplied(String value) {
            if (this.applied == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return AppliedNameForms.checkPreconditions(new AppliedNameForms(this, this.forms, newValue, this.simple, this.isNew));
        }

        @Override
        public Constitution.NameForms forms() {
            return this.forms;
        }

        @Override
        public String applied() {
            return this.applied;
        }

        @Override
        public String simple() {
            return this.simple;
        }

        @Override
        public boolean isNew() {
            return this.isNew;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof AppliedNameForms && this.equalTo((AppliedNameForms)another);
        }

        private boolean equalTo(AppliedNameForms another) {
            return this.forms.equals(another.forms) && this.applied.equals(another.applied) && this.simple.equals(another.simple) && this.isNew == another.isNew;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.forms.hashCode();
            h = h * 17 + this.applied.hashCode();
            h = h * 17 + this.simple.hashCode();
            h = h * 17 + Booleans.hashCode((boolean)this.isNew);
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        private static AppliedNameForms checkPreconditions(AppliedNameForms instance) {
            return instance;
        }

        public static AppliedNameForms copyOf(Constitution.AppliedNameForms instance) {
            if (instance instanceof AppliedNameForms) {
                return (AppliedNameForms)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return AppliedNameForms.builder().forms(instance.forms()).applied(instance.applied()).build();
        }

        @Deprecated
        public static AppliedNameForms copyOf(AppliedNameForms instance) {
            return (AppliedNameForms)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 3L;
            private static final long INITIALIZED_BIT_FORMS = 1L;
            private static final long INITIALIZED_BIT_APPLIED = 2L;
            private long initializedBitset;
            @Nullable
            private Constitution.NameForms forms;
            @Nullable
            private String applied;

            private Builder() {
            }

            public final Builder forms(Constitution.NameForms forms) {
                this.forms = (Constitution.NameForms)Preconditions.checkNotNull((Object)forms);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder applied(String applied) {
                this.applied = (String)Preconditions.checkNotNull((Object)applied);
                this.initializedBitset |= 2L;
                return this;
            }

            public AppliedNameForms build() {
                this.checkRequiredAttributes();
                return AppliedNameForms.checkPreconditions(new AppliedNameForms(this));
            }

            private boolean formsIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean appliedIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 3L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build AppliedNameForms, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.formsIsSet() ? "forms" : null)).addValue((Object)(!this.appliedIsSet() ? "applied" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableConstitution.AppliedNameForms.Builder").omitNullValues().add("forms", (Object)this.forms).add("applied", (Object)this.applied).toString();
            }
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL_ = 1L;
        private static final long INITIALIZED_BIT_PROTOCLASS = 1L;
        private long initializedBitset;
        @Nullable
        private Proto.Protoclass protoclass;

        private Builder() {
        }

        public final Builder protoclass(Proto.Protoclass protoclass) {
            this.protoclass = (Proto.Protoclass)Preconditions.checkNotNull((Object)protoclass);
            this.initializedBitset |= 1L;
            return this;
        }

        public ImmutableConstitution build() {
            this.checkRequiredAttributes();
            return ImmutableConstitution.checkPreconditions(new ImmutableConstitution(this));
        }

        private boolean protoclassIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            return MoreObjects.toStringHelper((String)"Cannot build Constitution, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.protoclassIsSet() ? "protoclass" : null)).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ImmutableConstitution.Builder").omitNullValues().add("protoclass", (Object)this.protoclass).toString();
        }
    }
}

