/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;

public final class CustomImmutableAnnotations {
    private static final String ANNOTATIONS_OPTION_KEY = "META-INF/annotations/org.immutables.value.immutable";
    private static final Splitter ADDITIONAL_ANNOTATION_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();
    private static final ImmutableSet<String> ANNOTATIONS = CustomImmutableAnnotations.findExtensionAnnotations();

    private CustomImmutableAnnotations() {
    }

    public static ImmutableSet<String> annotations() {
        return ANNOTATIONS;
    }

    private static ImmutableSet<String> findExtensionAnnotations() {
        ArrayList annotations = Lists.newArrayList();
        ClassLoader classLoader = CustomImmutableAnnotations.class.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(ANNOTATIONS_OPTION_KEY);
            while (resources.hasMoreElements()) {
                URL nextElement = resources.nextElement();
                String lines = Resources.toString((URL)nextElement, (Charset)StandardCharsets.UTF_8);
                annotations.addAll(ADDITIONAL_ANNOTATION_SPLITTER.splitToList((CharSequence)lines));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FluentIterable.from((Iterable)annotations).toSet();
    }
}

