/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.immutables.generator.AnnotationMirrors;

final class Annotations {
    private static final String PREFIX_JAVA_LANG = "java.lang.";
    private static final String PREFIX_IMMUTABLES = "org.immutables.";
    private static final String PREFIX_JACKSON = "com.fasterxml.jackson.annotation.";
    private static final String PREFIX_JACKSON_DATABIND = "com.fasterxml.jackson.databind.annotation.";
    private static final String PREFIX_JACKSON_IGNORE_PROPERTIES = "com.fasterxml.jackson.annotation.JsonIgnoreProperties";
    static final String JACKSON_ANY_GETTER = "com.fasterxml.jackson.annotation.JsonAnyGetter";
    static final String NULLABLE_SIMPLE_NAME = "Nullable";

    private Annotations() {
    }

    static List<CharSequence> getAnnotationLines(Element element, Set<String> includeAnnotations, boolean includeJacksonAnnotations, ElementType elementType) {
        ArrayList lines = Lists.newArrayList();
        HashSet<String> seenAnnotations = new HashSet<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!Annotations.annotationTypeMatches(annotationElement, includeAnnotations, includeJacksonAnnotations, seenAnnotations) || !Annotations.annotationMatchesTarget(annotationElement, elementType)) continue;
            lines.add(AnnotationMirrors.toCharSequence((AnnotationMirror)annotationMirror));
        }
        return lines;
    }

    private static boolean annotationTypeMatches(TypeElement annotationElement, Set<String> includeAnnotations, boolean includeJacksonAnnotations, Set<String> seenAnnotations) {
        String qualifiedName = annotationElement.getQualifiedName().toString();
        if (seenAnnotations.contains(qualifiedName) || qualifiedName.startsWith(PREFIX_IMMUTABLES) || qualifiedName.startsWith(PREFIX_JAVA_LANG)) {
            return false;
        }
        seenAnnotations.add(qualifiedName);
        if (annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) {
            return false;
        }
        if (qualifiedName.equals(PREFIX_JACKSON_IGNORE_PROPERTIES)) {
            return true;
        }
        if (includeJacksonAnnotations && (qualifiedName.startsWith(PREFIX_JACKSON) || qualifiedName.startsWith(PREFIX_JACKSON_DATABIND))) {
            return true;
        }
        if (includeAnnotations.contains(qualifiedName)) {
            return true;
        }
        for (AnnotationMirror annotationMirror : annotationElement.getAnnotationMirrors()) {
            TypeElement parentElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!Annotations.annotationTypeMatches(parentElement, includeAnnotations, includeJacksonAnnotations, seenAnnotations)) continue;
            return true;
        }
        return false;
    }

    static boolean annotationMatchesTarget(Element annotationElement, ElementType elementType) {
        Target target = annotationElement.getAnnotation(Target.class);
        if (target != null) {
            ElementType[] targetTypes = target.value();
            if (targetTypes.length == 0) {
                return false;
            }
            boolean found = false;
            for (ElementType t : targetTypes) {
                if (t != elementType) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }
}

