/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.with.Copied;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Copied", generator="Immutables")
@Immutable
final class ImmutableCopied
extends Copied {
    private final int attr;
    @Nullable
    private final Void voids;
    private final String[] arr;
    private final ImmutableMap<String, Integer> map;
    private final ImmutableList<Boolean> list;

    private ImmutableCopied(int attr, @Nullable Void voids, String[] arr, ImmutableMap<String, Integer> map, ImmutableList<Boolean> list) {
        this.attr = attr;
        this.voids = voids;
        this.arr = arr;
        this.map = map;
        this.list = list;
    }

    @Override
    public int attr() {
        return this.attr;
    }

    @Override
    @Nullable
    public Void voids() {
        return this.voids;
    }

    @Override
    public String[] arr() {
        return (String[])this.arr.clone();
    }

    public ImmutableMap<String, Integer> map() {
        return this.map;
    }

    public ImmutableList<Boolean> list() {
        return this.list;
    }

    @Override
    public final ImmutableCopied withAttr(int value) {
        if (this.attr == value) {
            return this;
        }
        return new ImmutableCopied(value, this.voids, this.arr, this.map, this.list);
    }

    @Override
    public final ImmutableCopied withVoids(@Nullable Void value) {
        if (this.voids == value) {
            return this;
        }
        return new ImmutableCopied(this.attr, value, this.arr, this.map, this.list);
    }

    @Override
    public final ImmutableCopied withArr(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableCopied(this.attr, this.voids, newValue, this.map, this.list);
    }

    @Override
    public final ImmutableCopied withMap(Map<String, ? extends Integer> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCopied(this.attr, this.voids, this.arr, (ImmutableMap<String, Integer>)newValue, this.list);
    }

    @Override
    public final ImmutableCopied withList(boolean ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Booleans.asList((boolean[])elements));
        return new ImmutableCopied(this.attr, this.voids, this.arr, this.map, (ImmutableList<Boolean>)newValue);
    }

    @Override
    public final ImmutableCopied withList(Iterable<Boolean> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCopied(this.attr, this.voids, this.arr, this.map, (ImmutableList<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCopied && this.equalTo(0, (ImmutableCopied)another);
    }

    private boolean equalTo(int synthetic, ImmutableCopied another) {
        return this.attr == another.attr && Objects.equals(this.voids, another.voids) && Arrays.equals(this.arr, another.arr) && this.map.equals(another.map) && this.list.equals(another.list);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attr;
        h += (h << 5) + Objects.hashCode(this.voids);
        h += (h << 5) + Arrays.hashCode(this.arr);
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.list.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Copied").omitNullValues().add("attr", this.attr).add("voids", (Object)this.voids).add("arr", (Object)Arrays.toString(this.arr)).add("map", this.map).add("list", this.list).toString();
    }

    public static ImmutableCopied copyOf(Copied instance) {
        if (instance instanceof ImmutableCopied) {
            return (ImmutableCopied)instance;
        }
        return new Copied.Builder().from(instance).build();
    }

    @Generated(from="Copied", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_ATTR = 1L;
        private static final long INIT_BIT_ARR = 2L;
        private long initBits = 3L;
        private int attr;
        @Nullable
        private Void voids;
        @Nullable
        private String[] arr;
        private ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
        private ImmutableList.Builder<Boolean> list = ImmutableList.builder();

        public Builder() {
            if (!(this instanceof Copied.Builder)) {
                throw new UnsupportedOperationException("Use: new Copied.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final Copied.Builder from(Copied instance) {
            Objects.requireNonNull(instance, "instance");
            this.attr(instance.attr());
            Void voidsValue = instance.voids();
            if (voidsValue != null) {
                this.voids(voidsValue);
            }
            this.arr(instance.arr());
            this.putAllMap(instance.map());
            this.addAllList(instance.list());
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder attr(int attr) {
            this.attr = attr;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder voids(@Nullable Void voids) {
            this.voids = voids;
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder arr(String ... arr) {
            this.arr = (String[])arr.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder putMap(String key, int value) {
            this.map.put((Object)key, (Object)value);
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder putMap(Map.Entry<String, ? extends Integer> entry) {
            this.map.put(entry);
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder map(Map<String, ? extends Integer> entries) {
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Copied.Builder putAllMap(Map<String, ? extends Integer> entries) {
            this.map.putAll(entries);
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder addList(boolean element) {
            this.list.add((Object)element);
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder addList(boolean ... elements) {
            this.list.addAll((Iterable)Booleans.asList((boolean[])elements));
            return (Copied.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Copied.Builder list(Iterable<Boolean> elements) {
            this.list = ImmutableList.builder();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Copied.Builder addAllList(Iterable<Boolean> elements) {
            this.list.addAll(elements);
            return (Copied.Builder)this;
        }

        public ImmutableCopied build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCopied(this.attr, this.voids, this.arr, this.map.build(), this.list.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arr");
            }
            return "Cannot build Copied, some of required attributes are not set " + attributes;
        }
    }
}

