/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.AbstractValueNamingDetected;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractValueNamingDetected", generator="Immutables")
@Immutable
public final class ValueNamingDetected
extends AbstractValueNamingDetected {
    private final int val;
    private final ImmutableSet<String> str;

    private ValueNamingDetected(int val, ImmutableSet<String> str) {
        this.val = val;
        this.str = str;
    }

    @Override
    public int extractVal() {
        return this.val;
    }

    public ImmutableSet<String> collectStr() {
        return this.str;
    }

    public final ValueNamingDetected withVal(int value) {
        if (this.val == value) {
            return this;
        }
        return new ValueNamingDetected(value, this.str);
    }

    public final ValueNamingDetected withStr(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ValueNamingDetected(this.val, (ImmutableSet<String>)newValue);
    }

    public final ValueNamingDetected withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ValueNamingDetected(this.val, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ValueNamingDetected && this.equalTo(0, (ValueNamingDetected)another);
    }

    private boolean equalTo(int synthetic, ValueNamingDetected another) {
        return this.val == another.val && this.str.equals(another.str);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.val;
        h += (h << 5) + this.str.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueNamingDetected").omitNullValues().add("val", this.val).add("str", this.str).toString();
    }

    static ValueNamingDetected copyOf(AbstractValueNamingDetected instance) {
        if (instance instanceof ValueNamingDetected) {
            return (ValueNamingDetected)instance;
        }
        return ValueNamingDetected.newBuilder().from(instance).buildValueNamingDetected();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Generated(from="AbstractValueNamingDetected", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VAL = 1L;
        private long initBits = 1L;
        private int val;
        private ImmutableSet.Builder<String> str = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder from(ValueNamingDetected instance) {
            return this.from((AbstractValueNamingDetected)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(AbstractValueNamingDetected instance) {
            Objects.requireNonNull(instance, "instance");
            this.usingVal(instance.extractVal());
            this.addAllStr(instance.collectStr());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usingVal(int val) {
            this.val = val;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withStrAppended(String element) {
            this.str.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withStrAppended(String ... elements) {
            this.str.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usingStr(Iterable<String> elements) {
            this.str = ImmutableSet.builder();
            return this.addAllStr(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStr(Iterable<String> elements) {
            this.str.addAll(elements);
            return this;
        }

        public ValueNamingDetected buildValueNamingDetected() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ValueNamingDetected(this.val, this.str.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("val");
            }
            return "Cannot build ValueNamingDetected, some of required attributes are not set " + attributes;
        }
    }
}

