/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.NoValidation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NoValidation", generator="Immutables")
@Immutable
public final class ImmutableNoValidation
implements NoValidation {
    private final String a;
    private final Integer b;
    private final boolean z;
    private final int i;
    private final List<String> list;
    private final Set<String> set;
    private final Map<String, Object> map;
    private final String c;

    private ImmutableNoValidation(String a, Integer b, boolean z, int i) {
        this.a = a;
        this.b = b;
        this.z = z;
        this.i = i;
        this.list = Collections.emptyList();
        this.set = Collections.emptySet();
        this.map = Collections.emptyMap();
        this.c = NoValidation.super.c();
    }

    private ImmutableNoValidation(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.z = builder.z;
        this.i = builder.i;
        this.list = ImmutableNoValidation.createUnmodifiableList(true, builder.list);
        this.set = ImmutableNoValidation.createUnmodifiableSet(builder.set);
        this.map = ImmutableNoValidation.createUnmodifiableMap(false, false, builder.map);
        this.c = builder.cIsSet() ? builder.c : NoValidation.super.c();
    }

    private ImmutableNoValidation(String a, Integer b, boolean z, int i, List<String> list, Set<String> set, Map<String, Object> map, String c) {
        this.a = a;
        this.b = b;
        this.z = z;
        this.i = i;
        this.list = list;
        this.set = set;
        this.map = map;
        this.c = c;
    }

    @Override
    public String a() {
        return this.a;
    }

    @Override
    public Integer b() {
        return this.b;
    }

    @Override
    public boolean z() {
        return this.z;
    }

    @Override
    public int i() {
        return this.i;
    }

    @Override
    public List<String> list() {
        return this.list;
    }

    @Override
    public Set<String> set() {
        return this.set;
    }

    @Override
    public Map<String, Object> map() {
        return this.map;
    }

    @Override
    public String c() {
        return this.c;
    }

    public final ImmutableNoValidation withA(String value) {
        if (Objects.equals(this.a, value)) {
            return this;
        }
        return new ImmutableNoValidation(value, this.b, this.z, this.i, this.list, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withB(Integer value) {
        if (Objects.equals(this.b, value)) {
            return this;
        }
        return new ImmutableNoValidation(this.a, value, this.z, this.i, this.list, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withZ(boolean value) {
        if (this.z == value) {
            return this;
        }
        return new ImmutableNoValidation(this.a, this.b, value, this.i, this.list, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withI(int value) {
        if (this.i == value) {
            return this;
        }
        return new ImmutableNoValidation(this.a, this.b, this.z, value, this.list, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withList(String ... elements) {
        List<String> newValue = ImmutableNoValidation.createUnmodifiableList(false, ImmutableNoValidation.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, newValue, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withList(Iterable<String> elements) {
        if (this.list == elements) {
            return this;
        }
        List<String> newValue = ImmutableNoValidation.createUnmodifiableList(false, ImmutableNoValidation.createSafeList(elements, false, false));
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, newValue, this.set, this.map, this.c);
    }

    public final ImmutableNoValidation withSet(String ... elements) {
        Set<String> newValue = ImmutableNoValidation.createUnmodifiableSet(ImmutableNoValidation.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, newValue, this.map, this.c);
    }

    public final ImmutableNoValidation withSet(Iterable<String> elements) {
        if (this.set == elements) {
            return this;
        }
        Set<String> newValue = ImmutableNoValidation.createUnmodifiableSet(ImmutableNoValidation.createSafeList(elements, false, false));
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, newValue, this.map, this.c);
    }

    public final ImmutableNoValidation withMap(Map<String, ? extends Object> entries) {
        if (this.map == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableNoValidation.createUnmodifiableMap(false, false, entries);
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, this.set, newValue, this.c);
    }

    public final ImmutableNoValidation withC(String value) {
        String newValue = value;
        if (this.c.equals(newValue)) {
            return this;
        }
        return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, this.set, this.map, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNoValidation && this.equalTo(0, (ImmutableNoValidation)another);
    }

    private boolean equalTo(int synthetic, ImmutableNoValidation another) {
        return Objects.equals(this.a, another.a) && Objects.equals(this.b, another.b) && this.z == another.z && this.i == another.i && this.list.equals(another.list) && this.set.equals(another.set) && this.map.equals(another.map) && this.c.equals(another.c);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.a);
        h += (h << 5) + Objects.hashCode(this.b);
        h += (h << 5) + Boolean.hashCode(this.z);
        h += (h << 5) + this.i;
        h += (h << 5) + this.list.hashCode();
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.c.hashCode();
        return h;
    }

    public String toString() {
        return "NoValidation{a=" + this.a + ", b=" + this.b + ", z=" + this.z + ", i=" + this.i + ", list=" + this.list + ", set=" + this.set + ", map=" + this.map + ", c=" + this.c + "}";
    }

    public static ImmutableNoValidation of(String a, Integer b, boolean z, int i) {
        return new ImmutableNoValidation(a, b, z, i);
    }

    public static ImmutableNoValidation copyOf(NoValidation instance) {
        if (instance instanceof ImmutableNoValidation) {
            return (ImmutableNoValidation)instance;
        }
        return ImmutableNoValidation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NoValidation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_C = 1L;
        private long optBits;
        @Nullable
        private String a;
        @Nullable
        private Integer b;
        private boolean z;
        private int i;
        private List<String> list = new ArrayList<String>();
        private List<String> set = new ArrayList<String>();
        private Map<String, Object> map = new LinkedHashMap<String, Object>();
        @Nullable
        private String c;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NoValidation instance) {
            Integer bValue;
            Objects.requireNonNull(instance, "instance");
            String aValue = instance.a();
            if (aValue != null) {
                this.a(aValue);
            }
            if ((bValue = instance.b()) != null) {
                this.b(bValue);
            }
            this.z(instance.z());
            this.i(instance.i());
            this.addAllList(instance.list());
            this.addAllSet(instance.set());
            this.putAllMap(instance.map());
            this.c(instance.c());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(String a) {
            this.a = a;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(Integer b) {
            this.b = b;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder z(boolean z) {
            this.z = z;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder i(int i) {
            this.i = i;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(@Nullable String element) {
            this.list.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String ... elements) {
            for (String element : elements) {
                this.list.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder list(Iterable<String> elements) {
            this.list.clear();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllList(Iterable<String> elements) {
            for (String element : elements) {
                this.list.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(@Nullable String element) {
            this.set.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(String ... elements) {
            for (String element : elements) {
                this.set.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder set(Iterable<String> elements) {
            this.set.clear();
            return this.addAllSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSet(Iterable<String> elements) {
            for (String element : elements) {
                this.set.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(@Nullable String key, @Nullable Object value) {
            this.map.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.map.put(k, v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(Map<String, ? extends Object> entries) {
            this.map.clear();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.map.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder c(String c) {
            this.c = c;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNoValidation build() {
            return new ImmutableNoValidation(this);
        }

        private boolean cIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

