/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.strict.Aar;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Aar", generator="Immutables")
@Immutable
final class ImmutableAar
implements Aar {
    private final boolean bl;
    private final Integer integer;

    private ImmutableAar(boolean bl, Integer integer) {
        this.bl = bl;
        this.integer = integer;
    }

    @Override
    public boolean bl() {
        return this.bl;
    }

    @Override
    public Integer integer() {
        return this.integer;
    }

    public final ImmutableAar withBl(boolean value) {
        if (this.bl == value) {
            return this;
        }
        return new ImmutableAar(value, this.integer);
    }

    public final ImmutableAar withInteger(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "integer");
        if (this.integer.equals(newValue)) {
            return this;
        }
        return new ImmutableAar(this.bl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAar && this.equalTo(0, (ImmutableAar)another);
    }

    private boolean equalTo(int synthetic, ImmutableAar another) {
        return this.bl == another.bl && this.integer.equals(another.integer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.bl);
        h += (h << 5) + this.integer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Aar").omitNullValues().add("bl", this.bl).add("integer", (Object)this.integer).toString();
    }

    public static ImmutableAar copyOf(Aar instance) {
        if (instance instanceof ImmutableAar) {
            return (ImmutableAar)instance;
        }
        return ImmutableAar.builder().bl(instance.bl()).integer(instance.integer()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Aar", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BL = 1L;
        private static final long INIT_BIT_INTEGER = 2L;
        private long initBits = 3L;
        private boolean bl;
        @Nullable
        private Integer integer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder bl(boolean bl) {
            Builder.checkNotIsSet(this.blIsSet(), "bl");
            this.bl = bl;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder integer(Integer integer) {
            Builder.checkNotIsSet(this.integerIsSet(), "integer");
            this.integer = Objects.requireNonNull(integer, "integer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAar build() {
            this.checkRequiredAttributes();
            return new ImmutableAar(this.bl, this.integer);
        }

        private boolean blIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean integerIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Aar is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.blIsSet()) {
                attributes.add("bl");
            }
            if (!this.integerIsSet()) {
                attributes.add("integer");
            }
            return "Cannot build Aar, some of required attributes are not set " + attributes;
        }
    }
}

