/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.NullableDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableDefault", generator="Immutables")
@Immutable
public final class ImmutableNullableDefault
implements NullableDefault {
    @Nullable
    private final String str;
    @Nullable
    private final Integer intr;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNullableDefault(Builder builder) {
        if (builder.strIsSet()) {
            this.initShim.str(builder.str);
        }
        if (builder.intrIsSet()) {
            this.initShim.intr(builder.intr);
        }
        this.str = this.initShim.str();
        this.intr = this.initShim.intr();
        this.initShim = null;
    }

    private ImmutableNullableDefault(@Nullable String str, @Nullable Integer intr) {
        this.str = str;
        this.intr = intr;
        this.initShim = null;
    }

    @Nullable
    private String strInitialize() {
        return NullableDefault.super.str();
    }

    @Nullable
    private Integer intrInitialize() {
        return NullableDefault.super.intr();
    }

    @Override
    @Nullable
    public String str() {
        InitShim shim = this.initShim;
        return shim != null ? shim.str() : this.str;
    }

    @Override
    @Nullable
    public Integer intr() {
        InitShim shim = this.initShim;
        return shim != null ? shim.intr() : this.intr;
    }

    public final ImmutableNullableDefault withStr(@Nullable String value) {
        if (Objects.equals(this.str, value)) {
            return this;
        }
        return new ImmutableNullableDefault(value, this.intr);
    }

    public final ImmutableNullableDefault withIntr(@Nullable Integer value) {
        if (Objects.equals(this.intr, value)) {
            return this;
        }
        return new ImmutableNullableDefault(this.str, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableDefault && this.equalTo(0, (ImmutableNullableDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableDefault another) {
        return Objects.equals(this.str, another.str) && Objects.equals(this.intr, another.intr);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.str);
        h += (h << 5) + Objects.hashCode(this.intr);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableDefault").omitNullValues().add("str", (Object)this.str).add("intr", (Object)this.intr).toString();
    }

    public static ImmutableNullableDefault copyOf(NullableDefault instance) {
        if (instance instanceof ImmutableNullableDefault) {
            return (ImmutableNullableDefault)instance;
        }
        return ImmutableNullableDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableDefault", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_STR = 1L;
        private static final long OPT_BIT_INTR = 2L;
        private long optBits;
        @Nullable
        private String str;
        @Nullable
        private Integer intr;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableDefault instance) {
            Integer intrValue;
            Objects.requireNonNull(instance, "instance");
            String strValue = instance.str();
            if (strValue != null) {
                this.str(strValue);
            }
            if ((intrValue = instance.intr()) != null) {
                this.intr(intrValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder str(@Nullable String str) {
            this.str = str;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder intr(@Nullable Integer intr) {
            this.intr = intr;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableNullableDefault build() {
            return new ImmutableNullableDefault(this);
        }

        private boolean strIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean intrIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="NullableDefault", generator="Immutables")
    private final class InitShim {
        private byte strBuildStage = 0;
        private String str;
        private byte intrBuildStage = 0;
        private Integer intr;

        private InitShim() {
        }

        String str() {
            if (this.strBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strBuildStage == 0) {
                this.strBuildStage = (byte)-1;
                this.str = ImmutableNullableDefault.this.strInitialize();
                this.strBuildStage = 1;
            }
            return this.str;
        }

        void str(String str) {
            this.str = str;
            this.strBuildStage = 1;
        }

        Integer intr() {
            if (this.intrBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.intrBuildStage == 0) {
                this.intrBuildStage = (byte)-1;
                this.intr = ImmutableNullableDefault.this.intrInitialize();
                this.intrBuildStage = 1;
            }
            return this.intr;
        }

        void intr(Integer intr) {
            this.intr = intr;
            this.intrBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.strBuildStage == -1) {
                attributes.add("str");
            }
            if (this.intrBuildStage == -1) {
                attributes.add("intr");
            }
            return "Cannot build NullableDefault, attribute initializers form cycle " + attributes;
        }
    }
}

