/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.NullableAttributes;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableAttributes", generator="Immutables")
@Immutable
public final class ImmutableNullableAttributes
implements NullableAttributes {
    @Nullable
    private final Integer integer;
    @Nullable
    private final ImmutableList<String> list;
    @Nullable
    private final ImmutableSet<Integer> set;
    @Nullable
    private final Integer[] array;
    @Nullable
    private final Double[] defArray;
    @Nullable
    private final ImmutableMap<String, Object> map;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNullableAttributes(Builder builder) {
        this.integer = builder.integer;
        this.list = builder.list == null ? null : builder.list.build();
        this.array = builder.array;
        ImmutableMap<String, Object> immutableMap = this.map = builder.map == null ? null : builder.map.build();
        if (builder.setIsSet()) {
            this.initShim.set(builder.set == null ? null : builder.set.build());
        }
        if (builder.defArrayIsSet()) {
            this.initShim.defArray(builder.defArray);
        }
        this.set = this.initShim.set();
        this.defArray = this.initShim.defArray();
        this.initShim = null;
    }

    private ImmutableNullableAttributes(@Nullable Integer integer, @Nullable ImmutableList<String> list, @Nullable ImmutableSet<Integer> set, @Nullable Integer[] array, @Nullable Double[] defArray, @Nullable ImmutableMap<String, Object> map) {
        this.integer = integer;
        this.list = list;
        this.set = set;
        this.array = array;
        this.defArray = defArray;
        this.map = map;
        this.initShim = null;
    }

    @Nullable
    private Set<Integer> setInitialize() {
        return NullableAttributes.super.set();
    }

    @Nullable
    private Double[] defArrayInitialize() {
        return NullableAttributes.super.defArray();
    }

    @Override
    @JsonProperty(value="integer")
    @Nullable
    public Integer integer() {
        return this.integer;
    }

    @JsonProperty(value="list")
    @Nullable
    public ImmutableList<String> list() {
        return this.list;
    }

    @JsonProperty(value="set")
    @Nullable
    public ImmutableSet<Integer> set() {
        InitShim shim = this.initShim;
        return shim != null ? shim.set() : this.set;
    }

    @Override
    @JsonProperty(value="array")
    @Nullable
    public Integer[] array() {
        return this.array;
    }

    @Override
    @JsonProperty(value="defArray")
    @Nullable
    public Double[] defArray() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defArray() : this.defArray;
    }

    @JsonProperty(value="map")
    @Nullable
    public ImmutableMap<String, Object> map() {
        return this.map;
    }

    public final ImmutableNullableAttributes withInteger(@Nullable Integer value) {
        if (Objects.equals(this.integer, value)) {
            return this;
        }
        return new ImmutableNullableAttributes(value, this.list, this.set, this.array, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withList(String ... elements) {
        if (elements == null) {
            return new ImmutableNullableAttributes(this.integer, null, this.set, this.array, this.defArray, this.map);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableNullableAttributes(this.integer, (ImmutableList<String>)newValue, this.set, this.array, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withList(@Nullable Iterable<String> elements) {
        if (this.list == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableNullableAttributes(this.integer, (ImmutableList<String>)newValue, this.set, this.array, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withSet(int ... elements) {
        if (elements == null) {
            return new ImmutableNullableAttributes(this.integer, this.list, null, this.array, this.defArray, this.map);
        }
        ImmutableSet newValue = Ints.asList((int[])elements) == null ? null : ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableNullableAttributes(this.integer, this.list, (ImmutableSet<Integer>)newValue, this.array, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withSet(@Nullable Iterable<Integer> elements) {
        if (this.set == elements) {
            return this;
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf(elements);
        return new ImmutableNullableAttributes(this.integer, this.list, (ImmutableSet<Integer>)newValue, this.array, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withArray(Integer ... elements) {
        Integer[] newValue = elements == null ? null : (Integer[])elements.clone();
        return new ImmutableNullableAttributes(this.integer, this.list, this.set, newValue, this.defArray, this.map);
    }

    public final ImmutableNullableAttributes withDefArray(Double ... elements) {
        Double[] newValue = elements == null ? null : (Double[])elements.clone();
        return new ImmutableNullableAttributes(this.integer, this.list, this.set, this.array, newValue, this.map);
    }

    public final ImmutableNullableAttributes withMap(@Nullable Map<String, ? extends Object> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableNullableAttributes(this.integer, this.list, this.set, this.array, this.defArray, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableAttributes && this.equalTo(0, (ImmutableNullableAttributes)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableAttributes another) {
        return Objects.equals(this.integer, another.integer) && Objects.equals(this.list, another.list) && Objects.equals(this.set, another.set) && Arrays.equals((Object[])this.array, (Object[])another.array) && Arrays.equals((Object[])this.defArray, (Object[])another.defArray) && Objects.equals(this.map, another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.integer);
        h += (h << 5) + Objects.hashCode(this.list);
        h += (h << 5) + Objects.hashCode(this.set);
        h += (h << 5) + Arrays.hashCode((Object[])this.array);
        h += (h << 5) + Arrays.hashCode((Object[])this.defArray);
        h += (h << 5) + Objects.hashCode(this.map);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableAttributes").omitNullValues().add("integer", (Object)this.integer).add("list", this.list).add("set", this.set).add("array", (Object)Arrays.toString((Object[])this.array)).add("defArray", (Object)Arrays.toString((Object[])this.defArray)).add("map", this.map).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNullableAttributes fromJson(Json json) {
        Builder builder = ImmutableNullableAttributes.builder();
        if (json.integer != null) {
            builder.integer(json.integer);
        }
        if (json.list != null) {
            builder.addAllList(json.list);
        }
        if (json.setIsSet) {
            builder.addAllSet(json.set);
        }
        if (json.array != null) {
            builder.array(json.array);
        }
        if (json.defArrayIsSet) {
            builder.defArray(json.defArray);
        }
        if (json.map != null) {
            builder.putAllMap(json.map);
        }
        return builder.build();
    }

    public static ImmutableNullableAttributes copyOf(NullableAttributes instance) {
        if (instance instanceof ImmutableNullableAttributes) {
            return (ImmutableNullableAttributes)instance;
        }
        return ImmutableNullableAttributes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableAttributes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SET = 1L;
        private static final long OPT_BIT_DEF_ARRAY = 2L;
        private long optBits;
        @Nullable
        private Integer integer;
        private ImmutableList.Builder<String> list = null;
        private ImmutableSet.Builder<Integer> set = null;
        @Nullable
        private Integer[] array;
        @Nullable
        private Double[] defArray;
        private ImmutableMap.Builder<String, Object> map = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableAttributes instance) {
            Map<String, Object> mapValue;
            Double[] defArrayValue;
            Integer[] arrayValue;
            Set<Integer> setValue;
            List<String> listValue;
            Objects.requireNonNull(instance, "instance");
            Integer integerValue = instance.integer();
            if (integerValue != null) {
                this.integer(integerValue);
            }
            if ((listValue = instance.list()) != null) {
                this.addAllList(listValue);
            }
            if ((setValue = instance.set()) != null) {
                this.addAllSet(setValue);
            }
            if ((arrayValue = instance.array()) != null) {
                this.array(arrayValue);
            }
            if ((defArrayValue = instance.defArray()) != null) {
                this.defArray(defArrayValue);
            }
            if ((mapValue = instance.map()) != null) {
                this.putAllMap(mapValue);
            }
            return this;
        }

        @JsonProperty(value="integer")
        @CanIgnoreReturnValue
        public final Builder integer(@Nullable Integer integer) {
            this.integer = integer;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String element) {
            if (this.list == null) {
                this.list = ImmutableList.builder();
            }
            this.list.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addList(String ... elements) {
            if (this.list == null) {
                this.list = ImmutableList.builder();
            }
            this.list.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="list")
        @CanIgnoreReturnValue
        public final Builder list(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.list = null;
                return this;
            }
            this.list = ImmutableList.builder();
            return this.addAllList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllList(Iterable<String> elements) {
            Objects.requireNonNull(elements, "list element");
            if (this.list == null) {
                this.list = ImmutableList.builder();
            }
            this.list.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(int element) {
            if (this.set == null) {
                this.set = ImmutableSet.builder();
            }
            this.set.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(int ... elements) {
            if (this.set == null) {
                this.set = ImmutableSet.builder();
            }
            this.set.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="set")
        @CanIgnoreReturnValue
        public final Builder set(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.set = null;
                this.optBits |= 1L;
                return this;
            }
            this.set = ImmutableSet.builder();
            return this.addAllSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSet(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "set element");
            if (this.set == null) {
                this.set = ImmutableSet.builder();
            }
            this.set.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="array")
        @CanIgnoreReturnValue
        public final Builder array(Integer ... array) {
            this.array = array;
            return this;
        }

        @JsonProperty(value="defArray")
        @CanIgnoreReturnValue
        public final Builder defArray(Double ... defArray) {
            this.defArray = defArray;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, Object value) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put(entry);
            return this;
        }

        @JsonProperty(value="map")
        @CanIgnoreReturnValue
        public final Builder map(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.map = null;
                return this;
            }
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Object> entries) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.putAll(entries);
            return this;
        }

        public ImmutableNullableAttributes build() {
            return new ImmutableNullableAttributes(this);
        }

        private boolean setIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean defArrayIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NullableAttributes", generator="Immutables")
    static final class Json
    implements NullableAttributes {
        @Nullable
        Integer integer;
        @Nullable
        List<String> list = null;
        @Nullable
        Set<Integer> set = null;
        boolean setIsSet;
        @Nullable
        Integer[] array;
        @Nullable
        Double[] defArray;
        boolean defArrayIsSet;
        @Nullable
        Map<String, Object> map = null;

        Json() {
        }

        @JsonProperty(value="integer")
        public void setInteger(@Nullable Integer integer) {
            this.integer = integer;
        }

        @JsonProperty(value="list")
        public void setList(@Nullable List<String> list) {
            this.list = list;
        }

        @JsonProperty(value="set")
        public void setSet(@Nullable Set<Integer> set) {
            this.set = set;
            this.setIsSet = true;
        }

        @JsonProperty(value="array")
        public void setArray(@Nullable Integer[] array) {
            this.array = array;
        }

        @JsonProperty(value="defArray")
        public void setDefArray(@Nullable Double[] defArray) {
            this.defArray = defArray;
            this.defArrayIsSet = true;
        }

        @JsonProperty(value="map")
        public void setMap(@Nullable Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Integer integer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> list() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Integer> set() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer[] array() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double[] defArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> map() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="NullableAttributes", generator="Immutables")
    private final class InitShim {
        private byte setBuildStage = 0;
        private ImmutableSet<Integer> set;
        private byte defArrayBuildStage = 0;
        private Double[] defArray;

        private InitShim() {
        }

        ImmutableSet<Integer> set() {
            if (this.setBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.setBuildStage == 0) {
                this.setBuildStage = (byte)-1;
                this.set = ImmutableNullableAttributes.this.setInitialize() == null ? null : ImmutableSet.copyOf((Collection)ImmutableNullableAttributes.this.setInitialize());
                this.setBuildStage = 1;
            }
            return this.set;
        }

        void set(ImmutableSet<Integer> set) {
            this.set = set;
            this.setBuildStage = 1;
        }

        Double[] defArray() {
            if (this.defArrayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defArrayBuildStage == 0) {
                this.defArrayBuildStage = (byte)-1;
                this.defArray = ImmutableNullableAttributes.this.defArrayInitialize();
                this.defArrayBuildStage = 1;
            }
            return this.defArray;
        }

        void defArray(Double[] defArray) {
            this.defArray = defArray;
            this.defArrayBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.setBuildStage == -1) {
                attributes.add("set");
            }
            if (this.defArrayBuildStage == -1) {
                attributes.add("defArray");
            }
            return "Cannot build NullableAttributes, attribute initializers form cycle " + attributes;
        }
    }
}

