/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.NullAnnElements;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullAnnElements", generator="Immutables")
@Immutable
public final class ImmutableNullAnnElements
implements NullAnnElements {
    private final List<Void> al;
    private final List<String> sk;
    private final Map<String, Integer> bl;
    private final Map<String, Integer> sm;
    private final Set<String> rg;

    private ImmutableNullAnnElements(List<Void> al, List<String> sk, Map<String, Integer> bl, Map<String, Integer> sm, Set<String> rg) {
        this.al = al;
        this.sk = sk;
        this.bl = bl;
        this.sm = sm;
        this.rg = rg;
    }

    @Override
    public List<Void> al() {
        return this.al;
    }

    @Override
    public List<String> sk() {
        return this.sk;
    }

    @Override
    public Map<String, Integer> bl() {
        return this.bl;
    }

    @Override
    public Map<String, Integer> sm() {
        return this.sm;
    }

    @Override
    public Set<String> rg() {
        return this.rg;
    }

    public final ImmutableNullAnnElements withAl(Void ... elements) {
        List<Void> newValue = ImmutableNullAnnElements.createUnmodifiableList(false, ImmutableNullAnnElements.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableNullAnnElements(newValue, this.sk, this.bl, this.sm, this.rg);
    }

    public final ImmutableNullAnnElements withAl(Iterable<? extends Void> elements) {
        if (this.al == elements) {
            return this;
        }
        List<Void> newValue = ImmutableNullAnnElements.createUnmodifiableList(false, ImmutableNullAnnElements.createSafeList(elements, false, false));
        return new ImmutableNullAnnElements(newValue, this.sk, this.bl, this.sm, this.rg);
    }

    public final ImmutableNullAnnElements withSk(String ... elements) {
        List<String> newValue = ImmutableNullAnnElements.createUnmodifiableList(false, ImmutableNullAnnElements.createSafeList(Arrays.asList(elements), false, true));
        return new ImmutableNullAnnElements(this.al, newValue, this.bl, this.sm, this.rg);
    }

    public final ImmutableNullAnnElements withSk(Iterable<String> elements) {
        if (this.sk == elements) {
            return this;
        }
        List<String> newValue = ImmutableNullAnnElements.createUnmodifiableList(false, ImmutableNullAnnElements.createSafeList(elements, false, true));
        return new ImmutableNullAnnElements(this.al, newValue, this.bl, this.sm, this.rg);
    }

    public final ImmutableNullAnnElements withBl(Map<String, ? extends Integer> entries) {
        if (this.bl == entries) {
            return this;
        }
        Map<String, Integer> newValue = ImmutableNullAnnElements.createUnmodifiableMap(false, false, entries);
        return new ImmutableNullAnnElements(this.al, this.sk, newValue, this.sm, this.rg);
    }

    public final ImmutableNullAnnElements withSm(Map<String, ? extends Integer> entries) {
        if (this.sm == entries) {
            return this;
        }
        Map<String, Integer> newValue = ImmutableNullAnnElements.createUnmodifiableMap(false, true, entries);
        return new ImmutableNullAnnElements(this.al, this.sk, this.bl, newValue, this.rg);
    }

    public final ImmutableNullAnnElements withRg(String ... elements) {
        Set<String> newValue = ImmutableNullAnnElements.createUnmodifiableSet(ImmutableNullAnnElements.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableNullAnnElements(this.al, this.sk, this.bl, this.sm, newValue);
    }

    public final ImmutableNullAnnElements withRg(Iterable<String> elements) {
        if (this.rg == elements) {
            return this;
        }
        Set<String> newValue = ImmutableNullAnnElements.createUnmodifiableSet(ImmutableNullAnnElements.createSafeList(elements, true, false));
        return new ImmutableNullAnnElements(this.al, this.sk, this.bl, this.sm, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullAnnElements && this.equalTo(0, (ImmutableNullAnnElements)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullAnnElements another) {
        return this.al.equals(another.al) && this.sk.equals(another.sk) && this.bl.equals(another.bl) && this.sm.equals(another.sm) && this.rg.equals(another.rg);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.al.hashCode();
        h += (h << 5) + this.sk.hashCode();
        h += (h << 5) + this.bl.hashCode();
        h += (h << 5) + this.sm.hashCode();
        h += (h << 5) + this.rg.hashCode();
        return h;
    }

    public String toString() {
        return "NullAnnElements{al=" + this.al + ", sk=" + this.sk + ", bl=" + this.bl + ", sm=" + this.sm + ", rg=" + this.rg + "}";
    }

    public static ImmutableNullAnnElements copyOf(NullAnnElements instance) {
        if (instance instanceof ImmutableNullAnnElements) {
            return (ImmutableNullAnnElements)instance;
        }
        return ImmutableNullAnnElements.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NullAnnElements", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Void> al = new ArrayList<Void>();
        private List<String> sk = new ArrayList<String>();
        private Map<String, Integer> bl = new LinkedHashMap<String, Integer>();
        private Map<String, Integer> sm = new LinkedHashMap<String, Integer>();
        private List<String> rg = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NullAnnElements instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAl(instance.al());
            this.addAllSk(instance.sk());
            this.putAllBl(instance.bl());
            this.putAllSm(instance.sm());
            this.addAllRg(instance.rg());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAl(@Nullable Void element) {
            this.al.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAl(Void ... elements) {
            for (Void element : elements) {
                this.al.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder al(Iterable<? extends Void> elements) {
            this.al.clear();
            return this.addAllAl(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAl(Iterable<? extends Void> elements) {
            for (Void void_ : elements) {
                this.al.add(void_);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSk(@Nullable String element) {
            if (element != null) {
                this.sk.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSk(String ... elements) {
            for (String element : elements) {
                if (element == null) continue;
                this.sk.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sk(Iterable<String> elements) {
            this.sk.clear();
            return this.addAllSk(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSk(Iterable<String> elements) {
            for (String element : elements) {
                if (element == null) continue;
                this.sk.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBl(@Nullable String key, @Nullable Integer value) {
            this.bl.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBl(Map.Entry<String, ? extends Integer> entry) {
            String k = entry.getKey();
            Integer v = entry.getValue();
            this.bl.put(k, v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bl(Map<String, ? extends Integer> entries) {
            this.bl.clear();
            return this.putAllBl(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBl(Map<String, ? extends Integer> entries) {
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                String k = e.getKey();
                Integer v = e.getValue();
                this.bl.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSm(@Nullable String key, @Nullable Integer value) {
            if (value != null && key != null) {
                this.sm.put(key, value);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSm(Map.Entry<String, ? extends Integer> entry) {
            String k = entry.getKey();
            Integer v = entry.getValue();
            if (k != null && v != null) {
                this.sm.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sm(Map<String, ? extends Integer> entries) {
            this.sm.clear();
            return this.putAllSm(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSm(Map<String, ? extends Integer> entries) {
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                String k = e.getKey();
                Integer v = e.getValue();
                if (k == null || v == null) continue;
                this.sm.put(k, v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRg(String element) {
            this.rg.add(Objects.requireNonNull(element, "rg element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRg(String ... elements) {
            for (String element : elements) {
                this.rg.add(Objects.requireNonNull(element, "rg element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rg(Iterable<String> elements) {
            this.rg.clear();
            return this.addAllRg(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRg(Iterable<String> elements) {
            for (String element : elements) {
                this.rg.add(Objects.requireNonNull(element, "rg element"));
            }
            return this;
        }

        public ImmutableNullAnnElements build() {
            return new ImmutableNullAnnElements(ImmutableNullAnnElements.createUnmodifiableList(true, this.al), ImmutableNullAnnElements.createUnmodifiableList(true, this.sk), ImmutableNullAnnElements.createUnmodifiableMap(false, false, this.bl), ImmutableNullAnnElements.createUnmodifiableMap(false, false, this.sm), ImmutableNullAnnElements.createUnmodifiableSet(this.rg));
        }
    }
}

