/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.FromNullCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FromNullCollection", generator="Immutables")
@Immutable
public final class ImmutableFromNullCollection
implements FromNullCollection {
    @Nullable
    private final ImmutableList<String> items;
    @Nullable
    private final ImmutableMap<Integer, String> freq;

    private ImmutableFromNullCollection(@Nullable ImmutableList<String> items, @Nullable ImmutableMap<Integer, String> freq) {
        this.items = items;
        this.freq = freq;
    }

    @Nullable
    public ImmutableList<String> getItems() {
        return this.items;
    }

    @Nullable
    public ImmutableMap<Integer, String> getFreq() {
        return this.freq;
    }

    public final ImmutableFromNullCollection withItems(String ... elements) {
        if (elements == null) {
            return new ImmutableFromNullCollection(null, this.freq);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableFromNullCollection((ImmutableList<String>)newValue, this.freq);
    }

    public final ImmutableFromNullCollection withItems(@Nullable Iterable<String> elements) {
        if (this.items == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableFromNullCollection((ImmutableList<String>)newValue, this.freq);
    }

    public final ImmutableFromNullCollection withFreq(@Nullable Map<Integer, ? extends String> entries) {
        if (this.freq == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableFromNullCollection(this.items, (ImmutableMap<Integer, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFromNullCollection && this.equalTo(0, (ImmutableFromNullCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableFromNullCollection another) {
        return Objects.equals(this.items, another.items) && Objects.equals(this.freq, another.freq);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.items);
        h += (h << 5) + Objects.hashCode(this.freq);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FromNullCollection").omitNullValues().add("items", this.items).add("freq", this.freq).toString();
    }

    public static ImmutableFromNullCollection copyOf(FromNullCollection instance) {
        if (instance instanceof ImmutableFromNullCollection) {
            return (ImmutableFromNullCollection)instance;
        }
        return ImmutableFromNullCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FromNullCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> items = null;
        private ImmutableMap.Builder<Integer, String> freq = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FromNullCollection instance) {
            Map<Integer, String> freqValue;
            Objects.requireNonNull(instance, "instance");
            List<String> itemsValue = instance.getItems();
            if (itemsValue != null) {
                this.addAllItems(itemsValue);
            }
            if ((freqValue = instance.getFreq()) != null) {
                this.putAllFreq(freqValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(String element) {
            if (this.items == null) {
                this.items = ImmutableList.builder();
            }
            this.items.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(String ... elements) {
            if (this.items == null) {
                this.items = ImmutableList.builder();
            }
            this.items.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder items(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.items = null;
                return this;
            }
            this.items = ImmutableList.builder();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<String> elements) {
            Objects.requireNonNull(elements, "items element");
            if (this.items == null) {
                this.items = ImmutableList.builder();
            }
            this.items.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFreq(int key, String value) {
            if (this.freq == null) {
                this.freq = ImmutableMap.builder();
            }
            this.freq.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFreq(Map.Entry<Integer, ? extends String> entry) {
            if (this.freq == null) {
                this.freq = ImmutableMap.builder();
            }
            this.freq.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder freq(@Nullable Map<Integer, ? extends String> entries) {
            if (entries == null) {
                this.freq = null;
                return this;
            }
            this.freq = ImmutableMap.builder();
            return this.putAllFreq(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFreq(Map<Integer, ? extends String> entries) {
            if (this.freq == null) {
                this.freq = ImmutableMap.builder();
            }
            this.freq.putAll(entries);
            return this;
        }

        public ImmutableFromNullCollection build() {
            return new ImmutableFromNullCollection(this.items == null ? null : this.items.build(), this.freq == null ? null : this.freq.build());
        }
    }
}

