/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ImmutableNullableListMap;
import org.immutables.fixture.modifiable.NullableListMap;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="NullableListMap", generator="Modifiables")
@NotThreadSafe
public final class ModifiableNullableListMap
implements NullableListMap {
    @Nullable
    private Object object;
    @Nullable
    private ArrayList<Object> objects = null;
    @Nullable
    private Map<String, String> map = null;

    private ModifiableNullableListMap() {
    }

    public static ModifiableNullableListMap create() {
        return new ModifiableNullableListMap();
    }

    @Override
    @Nullable
    public final Object getObject() {
        return this.object;
    }

    @Override
    @Nullable
    public final List<Object> getObjects() {
        return this.objects;
    }

    @Override
    @Nullable
    public final Map<String, String> getMap() {
        return this.map;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap clear() {
        this.object = null;
        this.objects = null;
        this.map = null;
        return this;
    }

    public ModifiableNullableListMap from(NullableListMap instance) {
        Map<String, String> mapValue;
        List<Object> objectsValue;
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableNullableListMap) {
            this.from((ModifiableNullableListMap)instance);
            return this;
        }
        Object objectValue = instance.getObject();
        if (objectValue != null) {
            this.setObject(objectValue);
        }
        if ((objectsValue = instance.getObjects()) != null) {
            this.addAllObjects(objectsValue);
        }
        if ((mapValue = instance.getMap()) != null) {
            this.putAllMap(mapValue);
        }
        return this;
    }

    public ModifiableNullableListMap from(ModifiableNullableListMap instance) {
        Map<String, String> mapValue;
        List<Object> objectsValue;
        Objects.requireNonNull(instance, "instance");
        Object objectValue = instance.getObject();
        if (objectValue != null) {
            this.setObject(objectValue);
        }
        if ((objectsValue = instance.getObjects()) != null) {
            this.addAllObjects(objectsValue);
        }
        if ((mapValue = instance.getMap()) != null) {
            this.putAllMap(mapValue);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap setObject(@Nullable Object object) {
        this.object = object;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap addObjects(Object element) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        Objects.requireNonNull(element, "objects element");
        this.objects.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableNullableListMap addObjects(Object ... elements) {
        for (Object e : elements) {
            this.addObjects(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap setObjects(@Nullable Iterable<? extends Object> elements) {
        if (elements == null) {
            this.objects = null;
            return this;
        }
        if (this.objects == null) {
            this.objects = new ArrayList();
        } else {
            this.objects.clear();
        }
        this.addAllObjects(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap addAllObjects(Iterable<? extends Object> elements) {
        if (elements == null) {
            return this;
        }
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        for (Object object : elements) {
            this.addObjects(object);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap putMap(String key, String value) {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, String>();
        }
        this.map.put(Objects.requireNonNull(key, "map key"), Objects.requireNonNull(value, "map value"));
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap setMap(@Nullable Map<String, ? extends String> entries) {
        if (entries == null) {
            this.map = null;
            return this;
        }
        if (this.map == null) {
            this.map = new LinkedHashMap<String, String>();
        } else {
            this.map.clear();
        }
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, "map value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableListMap putAllMap(Map<String, ? extends String> entries) {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, String>();
        }
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.map.put(Objects.requireNonNull(k, "map key"), Objects.requireNonNull(v, "map value"));
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableNullableListMap toImmutable() {
        return ImmutableNullableListMap.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableNullableListMap)) {
            return false;
        }
        ModifiableNullableListMap other = (ModifiableNullableListMap)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableNullableListMap another) {
        return Objects.equals(this.object, another.object) && Objects.equals(this.objects, another.objects) && Objects.equals(this.map, another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.object);
        h += (h << 5) + Objects.hashCode(this.objects);
        h += (h << 5) + Objects.hashCode(this.map);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableNullableListMap").add("object", this.getObject()).add("objects", this.getObjects()).add("map", this.getMap()).toString();
    }
}

