/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.AbstractImmutableWithModifiable;
import org.immutables.fixture.modifiable.ImmutableWithModifiable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractImmutableWithModifiable", generator="Modifiables")
@NotThreadSafe
public final class ModifiableImmutableWithModifiable
implements AbstractImmutableWithModifiable {
    private int id;
    private String description;
    private final ArrayList<String> names = new ArrayList();

    private ModifiableImmutableWithModifiable() {
    }

    public static ModifiableImmutableWithModifiable create() {
        return new ModifiableImmutableWithModifiable();
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final List<String> getNames() {
        return this.names;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable clear() {
        this.id = 0;
        this.description = null;
        this.names.clear();
        return this;
    }

    public ModifiableImmutableWithModifiable from(AbstractImmutableWithModifiable instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableImmutableWithModifiable) {
            this.from((ModifiableImmutableWithModifiable)instance);
            return this;
        }
        this.setId(instance.getId());
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
            this.setDescription(descriptionValue);
        }
        this.addAllNames(instance.getNames());
        return this;
    }

    public ModifiableImmutableWithModifiable from(ModifiableImmutableWithModifiable instance) {
        Objects.requireNonNull(instance, "instance");
        this.setId(instance.getId());
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
            this.setDescription(descriptionValue);
        }
        this.addAllNames(instance.getNames());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable setId(int id) {
        this.id = id;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable setDescription(String description) {
        this.description = description;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable addNames(String element) {
        Objects.requireNonNull(element, "names element");
        this.names.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableImmutableWithModifiable addNames(String ... elements) {
        for (String e : elements) {
            this.addNames(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable setNames(Iterable<String> elements) {
        this.names.clear();
        this.addAllNames(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableImmutableWithModifiable addAllNames(Iterable<String> elements) {
        for (String e : elements) {
            this.addNames(e);
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableWithModifiable toImmutable() {
        return ImmutableWithModifiable.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableImmutableWithModifiable)) {
            return false;
        }
        ModifiableImmutableWithModifiable other = (ModifiableImmutableWithModifiable)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableImmutableWithModifiable another) {
        return this.id == another.id && Objects.equals(this.description, another.description) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableImmutableWithModifiable{id=" + this.getId() + ", description=" + this.getDescription() + ", names=" + this.getNames() + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

