/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ModifiableVoidSetters;
import org.immutables.fixture.modifiable.VoidSetters;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VoidSetters", generator="Immutables")
@Immutable
public final class ImmutableVoidSetters
implements VoidSetters {
    private final int aa;
    private final String bb;
    private final ImmutableList<Double> cc;

    private ImmutableVoidSetters(int aa, String bb, ImmutableList<Double> cc) {
        this.aa = aa;
        this.bb = bb;
        this.cc = cc;
    }

    @Override
    public int getAa() {
        return this.aa;
    }

    @Override
    public String getBb() {
        return this.bb;
    }

    public ImmutableList<Double> getCc() {
        return this.cc;
    }

    public final ImmutableVoidSetters withAa(int value) {
        if (this.aa == value) {
            return this;
        }
        return new ImmutableVoidSetters(value, this.bb, this.cc);
    }

    public final ImmutableVoidSetters withBb(String value) {
        String newValue = Objects.requireNonNull(value, "bb");
        if (this.bb.equals(newValue)) {
            return this;
        }
        return new ImmutableVoidSetters(this.aa, newValue, this.cc);
    }

    public final ImmutableVoidSetters withCc(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return new ImmutableVoidSetters(this.aa, this.bb, (ImmutableList<Double>)newValue);
    }

    public final ImmutableVoidSetters withCc(Iterable<Double> elements) {
        if (this.cc == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableVoidSetters(this.aa, this.bb, (ImmutableList<Double>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVoidSetters && this.equalTo(0, (ImmutableVoidSetters)another);
    }

    private boolean equalTo(int synthetic, ImmutableVoidSetters another) {
        return this.aa == another.aa && this.bb.equals(another.bb) && this.cc.equals(another.cc);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.aa;
        h += (h << 5) + this.bb.hashCode();
        h += (h << 5) + this.cc.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VoidSetters").omitNullValues().add("aa", this.aa).add("bb", (Object)this.bb).add("cc", this.cc).toString();
    }

    public static ImmutableVoidSetters copyOf(VoidSetters instance) {
        if (instance instanceof ImmutableVoidSetters) {
            return (ImmutableVoidSetters)instance;
        }
        return ImmutableVoidSetters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VoidSetters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AA = 1L;
        private static final long INIT_BIT_BB = 2L;
        private long initBits = 3L;
        private int aa;
        @Nullable
        private String bb;
        private ImmutableList.Builder<Double> cc = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableVoidSetters instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.aaIsSet()) {
                this.aa(instance.getAa());
            }
            if (instance.bbIsSet()) {
                this.bb(instance.getBb());
            }
            this.addAllCc(instance.getCc());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(VoidSetters instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableVoidSetters) {
                return this.from((ModifiableVoidSetters)instance);
            }
            this.aa(instance.getAa());
            this.bb(instance.getBb());
            this.addAllCc(instance.getCc());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder aa(int aa) {
            this.aa = aa;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bb(String bb) {
            this.bb = Objects.requireNonNull(bb, "bb");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCc(double element) {
            this.cc.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCc(double ... elements) {
            this.cc.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cc(Iterable<Double> elements) {
            this.cc = ImmutableList.builder();
            return this.addAllCc(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCc(Iterable<Double> elements) {
            this.cc.addAll(elements);
            return this;
        }

        public ImmutableVoidSetters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVoidSetters(this.aa, this.bb, this.cc.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("aa");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bb");
            }
            return "Cannot build VoidSetters, some of required attributes are not set " + attributes;
        }
    }
}

