/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ModifiableNullableListMap;
import org.immutables.fixture.modifiable.NullableListMap;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableListMap", generator="Immutables")
@Immutable
public final class ImmutableNullableListMap
implements NullableListMap {
    @Nullable
    private final Object object;
    @Nullable
    private final ImmutableList<Object> objects;
    @Nullable
    private final ImmutableMap<String, String> map;

    private ImmutableNullableListMap(@Nullable Object object, @Nullable ImmutableList<Object> objects, @Nullable ImmutableMap<String, String> map) {
        this.object = object;
        this.objects = objects;
        this.map = map;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.object;
    }

    @Nullable
    public ImmutableList<Object> getObjects() {
        return this.objects;
    }

    @Nullable
    public ImmutableMap<String, String> getMap() {
        return this.map;
    }

    public final ImmutableNullableListMap withObject(@Nullable Object value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableNullableListMap(value, this.objects, this.map);
    }

    public final ImmutableNullableListMap withObjects(Object ... elements) {
        if (elements == null) {
            return new ImmutableNullableListMap(this.object, null, this.map);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableNullableListMap(this.object, (ImmutableList<Object>)newValue, this.map);
    }

    public final ImmutableNullableListMap withObjects(@Nullable Iterable<? extends Object> elements) {
        if (this.objects == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableNullableListMap(this.object, (ImmutableList<Object>)newValue, this.map);
    }

    public final ImmutableNullableListMap withMap(@Nullable Map<String, ? extends String> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableNullableListMap(this.object, this.objects, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableListMap && this.equalTo(0, (ImmutableNullableListMap)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableListMap another) {
        return Objects.equals(this.object, another.object) && Objects.equals(this.objects, another.objects) && Objects.equals(this.map, another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.object);
        h += (h << 5) + Objects.hashCode(this.objects);
        h += (h << 5) + Objects.hashCode(this.map);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableListMap").omitNullValues().add("object", this.object).add("objects", this.objects).add("map", this.map).toString();
    }

    public static ImmutableNullableListMap copyOf(NullableListMap instance) {
        if (instance instanceof ImmutableNullableListMap) {
            return (ImmutableNullableListMap)instance;
        }
        return ImmutableNullableListMap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableListMap", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Object object;
        private ImmutableList.Builder<Object> objects = null;
        private ImmutableMap.Builder<String, String> map = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableNullableListMap instance) {
            Map<String, String> mapValue;
            List<Object> objectsValue;
            Objects.requireNonNull(instance, "instance");
            Object objectValue = instance.getObject();
            if (objectValue != null) {
                this.object(objectValue);
            }
            if ((objectsValue = instance.getObjects()) != null) {
                this.addAllObjects(objectsValue);
            }
            if ((mapValue = instance.getMap()) != null) {
                this.putAllMap(mapValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableListMap instance) {
            Map<String, String> mapValue;
            List<Object> objectsValue;
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableNullableListMap) {
                return this.from((ModifiableNullableListMap)instance);
            }
            Object objectValue = instance.getObject();
            if (objectValue != null) {
                this.object(objectValue);
            }
            if ((objectsValue = instance.getObjects()) != null) {
                this.addAllObjects(objectsValue);
            }
            if ((mapValue = instance.getMap()) != null) {
                this.putAllMap(mapValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder object(@Nullable Object object) {
            this.object = object;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjects(Object element) {
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjects(Object ... elements) {
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objects(@Nullable Iterable<? extends Object> elements) {
            if (elements == null) {
                this.objects = null;
                return this;
            }
            this.objects = ImmutableList.builder();
            return this.addAllObjects(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjects(Iterable<? extends Object> elements) {
            Objects.requireNonNull(elements, "objects element");
            if (this.objects == null) {
                this.objects = ImmutableList.builder();
            }
            this.objects.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, String value) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends String> entry) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder map(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.map = null;
                return this;
            }
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends String> entries) {
            if (this.map == null) {
                this.map = ImmutableMap.builder();
            }
            this.map.putAll(entries);
            return this;
        }

        public ImmutableNullableListMap build() {
            return new ImmutableNullableListMap(this.object, this.objects == null ? null : this.objects.build(), this.map == null ? null : this.map.build());
        }
    }
}

